import contextlib
import cProfile
import pstats
import StringIO


@contextlib.contextmanager
def profile(lines=40):
    p = cProfile.Profile()
    p.enable()
    try:
        yield
    except (RuntimeError, AssertionError, KeyboardInterrupt):
        pass
    p.disable()
    s = StringIO.StringIO()
    ps = pstats.Stats(p, stream=s).sort_stats('cumulative')
    ps.print_stats(lines)
    print s.getvalue()
