# -*- coding: utf-8 -*-


class CtrlRunner(object):
    __name__ = 'ctrl_runner'

    def __init__(self, tier, port, env, readonly=True):
        self.__cfg__ = {
            'tier': tier,
            'readonly': readonly,
            'port': port,
            'logs-dir': '{srv}/logs',
            'env': env,
        }

    def start(self):
        self.create([
            self.find('runner'),
            '--tier', self.__cfg__['tier'],
            '--debug',
            '--readonly' if self.__cfg__['readonly'] else '--not-readonly',
            '--port', str(self.__cfg__['port']),
            '--logs-dir', self.__cfg__['logs-dir']
        ], env=self.__cfg__['env'])

    def packages(self):
        return ['runner.tgz']

    def logfiles(self):
        return [self.__cfg__['logs-dir'] + '/debug.log']

    def balancer(self):
        return {
            'domain': 'ctrl',
            'location': '/',
            'port': self.__cfg__['port'],
        }


class Plugin(object):
    __name__ = 'cajuper_test'

    def __init__(self, init_iface):
        pass

    def calc_secrets(self):
        secrets = {}
        with open('/home/cerg1168/.yt/token') as f:
            secrets['YT_TOKEN'] = f.read().strip()
        return secrets

    def conf(self):
        return {
            'key': 10,
            'groups': {
                'gencfg@MAN_CAJUPER_TEST_SAMOGON_GUEST': {},
            },
        }

    def gencluster(self, gencluster_iface):
        porter = gencluster_iface.porter()
        for host, info in gencluster_iface.host_list():
            yield host, CtrlRunner('pip', porter.host(host)(), gencluster_iface.secrets)
            break

    def moderators(self):
        return ['cerg1168', 'okats', 'mcden']
