from gevent import subprocess
from retry import retry
import logging

import infra.callisto.libraries.process as process


def sky_get(resource_url, dst_dir, timeout, max_dl_speed=None, max_ul_speed=None, copier_opts=None, hardlink=False):
    if 'rbtorrent' not in resource_url:
        resource_url = 'rbtorrent:' + resource_url

    args = [
        'sky', 'get',
        '--user',
        '--wait',
        '--timeout={}'.format(str(timeout)),
    ]
    if max_dl_speed:
        args += ['--max-dl-speed={}'.format(max_dl_speed)]
    if max_ul_speed:
        args += ['--max-ul-speed={}'.format(max_ul_speed)]
    if copier_opts:
        args += ['--opts={}'.format(copier_opts)]
    if hardlink:
        args += ['--deduplicate=Hardlink']
    args += [
        '--dir={}'.format(dst_dir),
        resource_url,
    ]

    return process.execute(args) == 0


@retry(tries=120, delay=60)
def sky_share(src_dir):
    cmd = ['sky share --dir="{}" $(cd "{}"; find -type f) || exit 1'.format(src_dir, src_dir)]
    logging.info('Call %s', str(cmd))

    p = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)
    out, err = p.communicate()
    return_code = p.returncode

    if return_code != 0:
        raise SubprocessException(cmd)

    return out.strip()


def _call_iss_shards_info(shard_id):
    cmd = ['./iss_shards', 'info', shard_id]
    logging.info('Call %s', str(cmd))

    return subprocess.Popen(
        cmd,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE).communicate()


def find_rbtorrent(shard_id):
    out, err = _call_iss_shards_info(shard_id)

    urls = [l.strip() for l in out.splitlines() if l.startswith('rbtorrent')]
    return urls[0] if urls else None


def is_registered_inc(shard_id):
    out, err = _call_iss_shards_info(shard_id)
    return 'Has incremental shard info' in out


class SubprocessException(Exception):
    def __init__(self, cmd):
        super(SubprocessException, self).__init__('[{}] failed'.format(cmd[0]))
