import gevent.monkey
gevent.monkey.patch_all()  # noqa

import os

import infra.callisto.libraries.logging as cajuper_logging

import conversation
import notificator
import settings
import monitor
import context


def get_token():
    return os.environ['TELEGRAM_TOKEN']


def main():
    cajuper_logging.configure_logging(path_to_logs='./logs', debug=True)

    token = get_token()
    monitor_ = monitor.Monitor()
    settings_ = settings.SettingsStorage()
    conf_handler_ = conversation.ConversationHandler(token)
    notificator_ = notificator.Notificator(token)

    context.init(settings_, monitor_)

    monitor_.start()
    conf_handler_.start()
    notificator_.start()
