import time
import logging
import datetime
import collections

import telegram

import utils
import context


class Notificator(object):
    def __init__(self, token):
        self._bot = telegram.Bot(token)
        self._prev_notification_time = collections.defaultdict(lambda: datetime.datetime.min)

    def _since_prev_notification(self, chat_id):
        return datetime.datetime.now() - self._prev_notification_time[chat_id]

    def _notify_chat(self, chat_id):
        settings = context.settings_storage().load_settings(chat_id)
        if not settings.enabled:
            return
        text = get_notifications(settings.projects, settings.current_level())
        if text and self._since_prev_notification(chat_id).total_seconds() > settings.notify_each_seconds:
            utils.send_message(self._bot, chat_id, text)
            self._prev_notification_time[chat_id] = datetime.datetime.now()

    def _iter(self):
        for chat_id in context.settings_storage().list_chats():
            try:
                self._notify_chat(chat_id)
            except Exception:
                logging.exception('')

    def start(self):
        while True:
            logging.debug('start iter')
            self._iter()
            time.sleep(15)


def get_notifications(projects, level=None):
    all_notifications = {}
    for project in projects:
        all_notifications[project] = context.monitor().project_notifications(project, level)
    return _notifications_to_text(all_notifications)


def _notifications_to_text(notifications):
    result = []
    for project in notifications:
        for source in notifications[project]:
            if notifications[project][source]:
                result.append(utils.source_notifications_to_text(
                    source, notifications[project][source],
                ))
    return '\n'.join(result)
