
PROJECTS = {}
SOURCES = {}

_CTRL_URL = 'http://ctrl.clusterstate.yandex-team.ru/{ctrl_path}/'


class Source(object):
    def __init__(self, name, ctrl_path):
        self._name = name
        self.ctrl_url = _CTRL_URL.format(ctrl_path=ctrl_path)
        self.notifications_url = self.ctrl_url + 'info/notifications'
        self.project = None

    @property
    def name(self):
        return '{}.{}'.format(self.project.name, self._name)

    def __str__(self):
        return 'Source({})'.format(self.name)


class Project(object):
    def __init__(self, name, sources):
        self.name = name
        self.sources = sources

        PROJECTS[name] = self
        for source in sources:
            source.project = self
            SOURCES[source.name] = source

    def __str__(self):
        return 'Project({})'.format(self.name)


def get_project(name):
    return PROJECTS[name]


def get_source(name):
    return SOURCES[name]


def list_projects():
    return [prj for prj_name, prj in sorted(PROJECTS.items())]


def list_sources():
    return [src for src_name, src in sorted(SOURCES.items())]


Project('jupiter', [
    Source('main', ctrl_path='web/prod'),
    Source('sas', ctrl_path='web/prod-sas'),
    Source('man', ctrl_path='web/prod-man'),
    Source('vla', ctrl_path='web/prod-vla'),
    Source('pip', ctrl_path='web/pip'),
])


Project('callisto', [
    Source('sas', ctrl_path='callisto/sas'),
    Source('man', ctrl_path='callisto/man'),
    Source('vla', ctrl_path='callisto/vla'),
])

Project('img', [
    Source('main', ctrl_path='img/prod'),
    Source('thumb', ctrl_path='img/thumb'),
    Source('pip', ctrl_path='img/pip'),
])

Project('video', [
    Source('main', ctrl_path='video/prod'),
    Source('sas', ctrl_path='video/prod-sas'),
    Source('man', ctrl_path='video/prod-man'),
    Source('vla', ctrl_path='video/prod-vla'),
    Source('pip', ctrl_path='video/pip'),
])

Project('web_betas', [
    Source('multi_beta', ctrl_path='web/multi_beta'),
    Source('multi_meta', ctrl_path='web/multi_meta'),
    Source('multi_int', ctrl_path='web/multiint'),
])

Project('img_betas', [
    Source('multi_beta', ctrl_path='img/multi_beta'),
    Source('multi_meta', ctrl_path='img/multi_meta'),
])

Project('video_betas', [
    Source('multi_beta', ctrl_path='video/multi_beta'),
    Source('multi_meta', ctrl_path='video/multi_meta'),
])
