

MAX_MESSAGE_LENGTH = 4096


def build_menu(
    buttons,
    n_cols,
    header_buttons=None,
    footer_buttons=None,
):
    menu = [buttons[i:i + n_cols] for i in range(0, len(buttons), n_cols)]
    if header_buttons:
        menu.insert(0, header_buttons)
    if footer_buttons:
        menu.append(footer_buttons)
    return menu


def try_combine(lines):
    result = []
    for line in lines:
        if result and len(result[-1]) + len(line) + 1 < MAX_MESSAGE_LENGTH:
            result[-1] += '\n' + line
        else:
            result.append(line)
    return result


def send_message(bot, chat_id, text):
    for message in try_combine(text.split('\n')):
        bot.send_message(chat_id, message, parse_mode='HTML')


def source_notifications_to_text(source, notifications):
    text = 'Notifications of <a href="{href}">{source}</a>:\n'.format(
        href=source.ctrl_url, source=source.name,
    )
    for notification in notifications:
        text += '[{level}] - {message}\n'.format(
            level=notification.level,
            message=notification.message,
        )
    return text
