import time
import logging
import datetime

import infra.callisto.libraries.logging as cajuper_logging
import infra.callisto.configs.mongo as mongo


def eternal_loop(func, sleep_seconds):
    logging.info('started eternal loop')

    while True:
        try:
            func()
        except RuntimeError:
            logging.exception('Exception')
        except Exception:
            logging.exception('Exception')
        finally:
            time.sleep(sleep_seconds)


def cleanup_1_ts_each_coll(cleaners, time_to_skip, timestamps_to_skip):
    for cleaner in cleaners:
        timestamps = cleaner.list_old_timestamps(time_to_skip, timestamps_to_skip)
        if timestamps:
            cleaner.remove_timestamp(min(timestamps))


def get_cleaners():
    lst = []
    for storage_factory in mongo.STORAGES.values():
        storage = storage_factory.get_storage()
        cleaner = storage.make_cleaner()
        lst.append(cleaner)
    return lst


def main():
    cajuper_logging.configure_logging(path_to_logs='./cleaner_logs', debug=True)
    logging.info('started cleaner')
    cleaners = get_cleaners()
    logging.info('collections are: %s', cleaners)

    def _f():
        cleanup_1_ts_each_coll(
            cleaners=cleaners,
            time_to_skip=datetime.timedelta(days=7),
            timestamps_to_skip=50,
        )

    eternal_loop(_f, 1)


if __name__ == '__main__':
    main()
