#pragma once

#include <util/generic/flags.h>


enum EResourceStatus {
    PREPARED = 0 /* "prepared" */,
    DOWNLOADING = 1 /* "downloading" */,
    IDLE = 2 /* "idle" */,
};

enum class ERemoteStoragePartSubResource {
    None    = 0b0 /* "none" */,
    Pudge   = 0b01 /* "pudge" */,
    Dynamic = 0b10 /* "dynamic" */,
    Ready   = Pudge | Dynamic,
};

Y_DECLARE_FLAGS(ERemoteStoragePartSubResources, ERemoteStoragePartSubResource);
Y_DECLARE_OPERATORS_FOR_FLAGS(ERemoteStoragePartSubResources);
