import json
import os

import infra.callisto.deploy.storage.storage as resources_storage

import common


class Env(common.Env):
    def __init__(self, vars_file_name):
        super(Env, self).__init__(vars_file_name)

    def db_timestamp(self):
        json_config = _get_lastconfig()
        return json_config['resource']['namespace'].split('/')[-3]

    def storage_root(self):
        generation_conf = self.env_file('generation.conf')
        if self.copy_on_ssd():
            return os.path.join('/ssd', generation_conf['GENERATION'])
        else:
            return os.path.join('/db/www', generation_conf['GENERATION'])

    def shard_name(self):
        json_config = _get_lastconfig()
        return json_config['shard']

    def tier_name(self):
        return _itag_by_prefix('a_tier')

    def copy_on_ssd(self):
        return 'itag_copy_on_ssd' in _itags()

    def config_name(self):
        return '{}:{}.cfg'.format(self.hostname(), _get_port())

    def rs_config_name(self):
        return '{}:{}.proto'.format(self.node_name(), _get_port())

    def deployer_namespace_path(self, tier_name):
        json_config = _get_lastconfig()
        namespace = json_config['resource']['namespace']
        return resources_storage.namespace_path(
            self.storage_root(),
            namespace,
        )

    def deployer_shard_path(self):
        json_config = _get_lastconfig()
        namespace = json_config['resource']['namespace']
        name = self._shard_name_for_path()
        return resources_storage.resource_path(
            self.storage_root(),
            namespace,
            name,
        )


def _get_lastconfig():
    with open(_get_lastconfig_name()) as fp:
        js = json.load(fp)

    return js


def _get_lastconfig_name():
    return '{}:{}.lastconfig.json'.format(_get_short_hostname(), _get_port())


def _get_short_hostname():
    fqdn = os.environ['HOSTNAME']
    return fqdn.split('.')[0]


def _get_port():
    return os.environ['BSCONFIG_IPORT']


def _itags():
    return os.environ['tags'].split(' ')


def _itag_by_prefix(prefix):
    for tag in _itags():
        if tag.startswith(prefix):
            return tag.replace(prefix, '').lstrip('_')
    raise RuntimeError('{} not found'.format(prefix))
