import argparse
import logging
import os

import actions
import deploy
import lastconfig
import nanny


def configure_logging():
    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--lastconfig', required=False, action='store_true', default=False)
    parser.add_argument('--vars-file-name', required=False, default="vars.conf", help="File containing environment vars")
    subparsers = parser.add_subparsers(dest='cmd')
    for name, action in actions.ACTIONS.items():
        action.add_args(subparsers.add_parser(name))
    return parser.parse_args()


def main():
    configure_logging()
    args = parse_args()
    if 'DEPLOY_BOX_ID' in os.environ:
        environment = deploy.Env(args.vars_file_name)
    elif args.lastconfig:
        environment = lastconfig.Env(args.vars_file_name)
    else:
        environment = nanny.Env(args.vars_file_name)
    action = actions.ACTIONS[args.cmd]()
    action.execute(environment, args)
