import os

import common


class Env(common.Env):
    def __init__(self, vars_file_name):
        super(Env, self).__init__(vars_file_name)

    def storage_root(self):
        generation_conf = self.env_file('generation.conf')
        storage_root = generation_conf['GENERATION']

        if os.path.isabs(storage_root):
            return storage_root

        if self.copy_on_ssd():
            return os.path.join('/ssd', storage_root)
        else:
            return os.path.join('/db/www', storage_root)

    def shard_name(self):
        template = _itag_by_prefix('a_shard')
        template = template.replace('0000000000', self.db_timestamp())
        template = template.replace('00000000-000000', common.timestamp_to_yt_state(self.db_timestamp()))
        return template

    def tier_name(self):
        return _itag_by_prefix('a_tier')

    def copy_on_ssd(self):
        return 'itag_copy_on_ssd' in _itags()

    def config_name(self):
        return '{}:{}.cfg'.format(self.hostname(), os.environ['BSCONFIG_IPORT'])

    def rs_config_name(self):
        return '{}:{}.proto'.format(self.node_name(), os.environ['BSCONFIG_IPORT'])

    def group(self):
        return _itag_by_prefix('a_topology_group')


def _itags():
    return os.environ['tags'].split(' ')


def _itag_by_prefix(prefix):
    for tag in _itags():
        if tag.startswith(prefix):
            return tag.replace(prefix, '').lstrip('_').lstrip('-')
    raise RuntimeError('{} not found'.format(prefix))
