import argparse
import logging

import infra.callisto.tools.jupiter_sla as jupiter_sla


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--solomon-token', help='token for solomon', required=True)
    return parser.parse_args()


def main():
    args = parse_args()

    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)

    jupiter_sla.execute(args.solomon_token)


if __name__ == '__main__':
    main()
