"""
Temporary incomplete replacement for portoctl, which is regretfully absent in ya.deploy workloads
"""

import porto
import sys


USAGE = 'Usage: portoctl.py get|set container property [value]'


def main():
    if len(sys.argv) < 4:
        print USAGE
        sys.exit(1)
    command = sys.argv[1]
    if command == 'get':
        assert len(sys.argv) == 4, USAGE
        print get(sys.argv[2], sys.argv[3])
    elif command == 'set':
        assert len(sys.argv) == 5, USAGE
        put(sys.argv[2], sys.argv[3], sys.argv[4])
    else:
        print USAGE
        sys.exit(1)


def get(container, prop):
    return porto.Connection().GetProperty(container, prop)


def put(container, prop, value):
    return porto.Connection().SetProperty(container, prop, value)
