import argparse
import logging
import sys

import yt.wrapper as yt


def configure_logging():
    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-cluster', help='YT cluster', required=True)
    parser.add_argument('--node', help='Node to check', required=True)

    return parser.parse_args()


def create_yt_client(proxy, use_rpc=False):
    yt_client = yt.YtClient(config=yt.config.config)
    yt_client.config['proxy']['url'] = proxy
    if use_rpc:
        yt_client.config['backend'] = 'rpc'
    return yt_client


def is_node_exists(yt_cluster, node):
    yt_client = create_yt_client(yt_cluster)

    e = yt_client.exists(node)

    return e


def main():
    configure_logging()
    args = parse_args()

    if is_node_exists(args.yt_cluster, args.node):
        sys.exit(0)

    sys.exit(1)
