import os
import sys
import argparse

from infra.capacity_planning.abc_request_list.dispenser_requests.lib.excel_generation import create_files


def get_dispenser_token():

    dispenser_token_path = os.path.expanduser("~/.dispenser/token")
    if not os.path.exists(dispenser_token_path):
        sys.stderr.write("OAuth key is absent: {}\n".format(dispenser_token_path))
        sys.stderr.write("Get it at # https://oauth.yandex-team.ru/authorize?response_type=token&client_id=fe21371385fa4ac8a24c2e9c318e0561\n")
        exit(1)

    with open(dispenser_token_path) as f:
        return f.read().strip()


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--campaign-ids', help='campaign ids', nargs='*', required=True)
    parser.add_argument('--session-id', help='session id', required=False)
    parser.add_argument('--api-timeout', help='api timeout', type=int, required=False)
    parser.add_argument('--token', help='token', required=False)
    parser.add_argument('--abc-token', help='abc_token', required=False)
    parser.add_argument('--hwr-orders-excel', help='hwr orders excel', required=False)
    parser.add_argument('--base-costs', help='base costs', required=False)
    parser.add_argument('--out-zip-path', help='out zip file path', required=False)
    parser.add_argument('--yoy-capex', help='YoY CAPEX', required=False)
    return parser.parse_args()


def main():

    args = parse_args()
    if args.token:
        token = args.token
    else:
        token = get_dispenser_token()

    create_files(
        token=token,
        abc_token=args.abc_token,
        campaign_ids=args.campaign_ids,
        api_timeout=args.api_timeout,
        base_costs_path=args.base_costs,
        hwr_orders_excel=args.hwr_orders_excel,
        out_zip_path=args.out_zip_path,
        session_id=args.session_id,
        yoy_capex=args.yoy_capex
    )
