# -*- coding: utf-8 -*-

from collections import defaultdict


def is_close(a, b, rel_tol=1e-09, abs_tol=0.0):
    return abs(a - b) <= max(rel_tol * max(abs(a), abs(b)), abs_tol)


def excel_colnum_string(n):
    string = ""
    while n > 0:
        n, remainder = divmod(n - 1, 26)
        string = chr(65 + remainder) + string
    return string


def remove_prefix(text, prefix):
    if text.startswith(prefix):
        return text[len(prefix):]
    return text


def convert_values(val, unit):
    if unit in ('BINARY_BPS', 'BPS'):
        return val / (1024.0 * 1024.0), "Mbps"
    elif unit == 'GIBIBYTE_BASE':
        return val / 1024.0, "Tb"
    elif unit == 'BYTE':
        return val / (1024.0 * 1024.0 * 1024.0 * 1024.0), "Tb"
    elif unit == 'PERMILLE_CORES':
        return val / 1000.0, "u"
    elif unit == 'PERMILLE':
        return val / 1000.0, "u"
    else:
        return val, unit


def prepare_simple_weights(print_totals):

    u_base_res_mappings = {
        'yt.': {
            'u_cpu_flow': 'cpu',
            'u_nirvana_cpu': 'cpu',
            'u_mem_burst': 'ram',
            'u_mem_strong': 'ram',
            'u_mem_relaxed': 'ram',
            'u_tablet_cell_bundle': 'slot',
            'u_rpc_proxy': 'rpc_slot',
            'u_tablet_static_memory': 'tablet_static_slot',
            'u_nirvana_gpu': 'gpu',
        },
        'yp.compute': {
            'u_cpu_segmented': 'cpu',
            'u_gencfg_cpu': 'cpu',
            'u_saas_cpu': 'cpu',
            'u_ram_segmented': 'ram',
            'u_gencfg_ram': 'ram',
            'u_saas_ram': 'ram',
            'u_ssd_segmented': 'ssd',
            'u_gencfg_ssd': 'ssd',
            'u_saas_ssd': 'ssd',
            'u_hdd_segmented': 'hdd',
            'u_gencfg_hdd': 'hdd',
            'u_saas_hdd': 'hdd',
            'u_io_hdd': 'io_hdd',
            'u_gencfg_io_hdd': 'io_hdd',
            'u_saas_io_hdd': 'io_hdd',
            'u_io_ssd': 'io_ssd',
            'u_gencfg_io_ssd': 'io_ssd',
            'u_saas_io_ssd': 'io_ssd',
        },
        'yp.gpu': {
            'u_gpu_segmented': 'gpu',
        },
        'logbroker.compute': {
            'u_data_flow_binary': 'dataflow',
        },
        'mds.compute': {
            'u_mds': 'storage',
            'u_s3-api': 'storage',
            'u_avatars': 'storage',
            'u_nirvana_s3-storage': 'storage',
        },
    }

    weights = defaultdict(lambda: defaultdict(float))
    for provider, provider_data in print_totals.items():
        for res_name, res_data in provider_data.items():
            res_weight = res_data['{}_{} (w)'.format(provider, res_name)]
            simple_res_name = res_name
            if provider.startswith('yt.'):
                if res_name in ('burst_cpu', 'cpu_day'):
                    simple_res_name = 'cpu'
                elif res_name in ('burst_ram', 'ram_day'):
                    simple_res_name = 'ram'
            weights[provider][simple_res_name] = max(weights[provider][simple_res_name], res_weight)

    return weights, u_base_res_mappings
