import os
import logging

HOST = os.environ.get("HOST", "https://hardware-request-defence.n.yandex-team.ru")
# must match URI in unified agent config
UNIFIED_AGENT_URI = os.environ.get("UNIFIED_AGENT_URI", 'unix:///tmp/dispenser_requests.sock')

# NOTE: if you change LOG_FORMAT, change parse rules accordingly https://a.yandex-team.ru/arc/trunk/arcadia/logfeller/configs/parsers/yp-quota-distributor-log.yaml
# NOTE: if you change LOG_DATEFTM, change parser timestamp format accordingly https://a.yandex-team.ru/arc/trunk/arcadia/logfeller/configs/parsers/parsers.auto.json?rev=7278045#L46549
LOG_FORMAT = '%(asctime)s\t%(levelname)s\t%(name)s\t%(message)s'
LOG_DATEFTM = '%Y-%m-%d %H:%M:%S'
LOG_FORMATTER = logging.Formatter(LOG_FORMAT, LOG_DATEFTM)
TOKEN = os.environ.get("TOKEN", "")

ADMINS = ["atridis", "glebskvortsov", "keyd", "sereglond", "chubinskiy"]

CAMPAIGN_CHOICES = [
    ((70, ), "aug2021"),
    ((37, ), "feb2021"),
    ((4, ), "aug2020"),
    ((4, 37), "aug2020 + feb2021"),
]
