
import time
import json
import shutil
from zipfile import ZipFile
from datetime import datetime

import library.python.resource as resource
from infra.capacity_planning.abc_request_list.dispenser_requests.lib.dispenser import DispenserApi
from infra.capacity_planning.abc_request_list.dispenser_requests.lib.abc_tree import AbcApi
from infra.capacity_planning.abc_request_list.dispenser_requests.lib.hwr import read_excel_data
from infra.capacity_planning.abc_request_list.dispenser_requests.lib.table import TableData
from infra.capacity_planning.abc_request_list.dispenser_requests.lib.targets import COST_TARGETS, process_targets


def unpack_excel_template(target_path):
    resource_path = '/templates/excel_vba_template.xlsm'
    template_file_data = resource.find(resource_path)
    with open(target_path, 'wb') as f:
        f.write(template_file_data)


def create_files(token, abc_token, campaign_ids, base_costs_path='', hwr_orders_excel='',
                 out_zip_path='', session_id=None, yoy_capex=0.0, api_timeout=None):
    def process_excel_file(prefix, postfix, file_paths_list, excel_creation_func):
        postfix_file_path = '{}.xlsm'.format(postfix)
        file_paths_list.append(postfix_file_path)
        post_pre_fix_file_path = '{}_{}.xlsm'.format(prefix, postfix)
        file_paths_list.append(post_pre_fix_file_path)

        unpack_excel_template(post_pre_fix_file_path)
        excel_creation_func(post_pre_fix_file_path)
        shutil.copy(post_pre_fix_file_path, postfix_file_path)

    t_start = time.perf_counter()

    base_costs = {}
    if base_costs_path:
        with open(base_costs_path, 'r') as f:
            base_costs = json.load(f)
    hwr_data = read_excel_data(hwr_orders_excel) if hwr_orders_excel else []

    abc_api = AbcApi(token=abc_token)
    abc_tree = abc_api.load_abc_service_tree()

    dispenser_client = DispenserApi(dispenser_token=token, session_id=session_id, timeout=api_timeout)

    quota_data_full = dispenser_client.get_quota_requests(campaign_ids, abc_tree=abc_tree)
    quota_data_full.extend(hwr_data)

    quota_limits_full = dispenser_client.get_limits(campaign_ids)
    targets_full = COST_TARGETS
    print('dispenser api: {}'.format(time.perf_counter() - t_start))

    date_prefix = datetime.now().strftime("%Y_%m_%d")
    table_full = TableData(quota_data_full, quota_limits_full, targets_full, base_costs=base_costs, yoy_capex=yoy_capex)
    print('full table calculations: {}'.format(time.perf_counter() - t_start))

    zip_file_paths = []
    process_excel_file(date_prefix, 'defence_full', zip_file_paths, table_full.create_excel_file)
    process_excel_file(date_prefix, 'defence_based_full', zip_file_paths, table_full.create_based_excel_file)
    process_excel_file(date_prefix, 'defence_yoy_full', zip_file_paths, table_full.create_yoy_excel_file)
    print('full table to excel : {}'.format(time.perf_counter() - t_start))

    quota_data_08 = dispenser_client.filter_quota_requests(quota_data_full, ['-06-30', '-09-30', ])
    quota_limits_08 = dispenser_client.multiply_limits(quota_limits_full, 0.8)
    targets_08 = process_targets(targets_full, multiplier=0.8)
    table_08 = TableData(quota_data_08, quota_limits_08, targets_08)
    print('06+09 table calculations: {}'.format(time.perf_counter() - t_start))

    process_excel_file(date_prefix, 'defence_06_09', zip_file_paths, table_08.create_excel_file)
    print('06+09 table to excel : {}'.format(time.perf_counter() - t_start))

    quota_data_06 = dispenser_client.filter_quota_requests(quota_data_full, ['-06-30', ])
    quota_limits_06 = dispenser_client.multiply_limits(quota_limits_full, 0.6)
    targets_06 = process_targets(targets_full, multiplier=0.6)
    table_06 = TableData(quota_data_06, quota_limits_06, targets_06)
    print('06 table calculations: {}'.format(time.perf_counter() - t_start))
    process_excel_file(date_prefix, 'defence_06', zip_file_paths, table_06.create_excel_file)
    print('06 table to excel : {}'.format(time.perf_counter() - t_start))

    if out_zip_path:
        with ZipFile(out_zip_path, 'w') as zip:
            for file_path in zip_file_paths:
                zip.write(file_path)
