# -*- coding: utf-8 -*-

import pandas as pd
from collections import OrderedDict

DOLLAR_PRICE = 72.4
TCO_COST = 2965.229446
SERVICE_RENAMINGS = {
    'Сервисы Поискового портала': 'Search Portal',
    'Сервисы Маркета': 'Market Services',
    'Сервисы экспериментов': 'Services of Experiments',
    'Яндекс.Облако': 'Yandex.Cloud',
    'Сервисы G&A': 'G&A services',
    'Экосистемные продукты ID+Pay (VS)': 'Ecosystem products ID+Pay (VS)',
    'Безопасность (VS)': 'InfoSec (VS)',
    'Инфраструктура (VS)': 'Infrastructure (VS)',
}
ADD_ORDER_IDS = (
    11332,
    11333,
)
SKIP_SERVICES = (
    'Сервисы Поискового портала > Инфраструктура (VS)'
)
BIG_ORDER_MAPPINGS = {
    '2022.06': '2022-06-30',
    '2022.09': '2022-09-30',
    '2022.12': '2022-12-31',
}


def read_excel_data(file_path, campaign_ids=None):
    campaign_ids = [] if campaign_ids is None else campaign_ids

    df = pd.read_excel(file_path)
    out_data = []
    for row in df.to_dict('records'):

        hwr_order_id = row['ID']
        big_order = str(row['Big order'])
        full_abc_service_path = row['ABC service']
        if full_abc_service_path.startswith(SKIP_SERVICES) and hwr_order_id not in ADD_ORDER_IDS:
            continue

        if big_order not in ['2022.06', '2022.09', '2022.12']:
            continue

        if big_order == '2022.06':
            big_order = '2022-06-30'
        elif big_order == '2022.09':
            big_order = '2022-09-30'
        elif big_order == '2022.12':
            big_order = '2022-12-31'

        hwr_order_id = row['ID']
        campaign = 'aug2021'
        server_count = row['Count']
        configuration_cost = row['Total configuration price']
        full_abc_components = full_abc_service_path.split(' > ')
        head_department_1 = SERVICE_RENAMINGS.get(full_abc_components[0], full_abc_components[0])
        head_department_2 = SERVICE_RENAMINGS.get(full_abc_components[1], full_abc_components[1]) if len(full_abc_components) > 1 else ''
        head_department_3 = full_abc_components[-1]

        new_row = {}
        new_row['details'] = OrderedDict(
            [
                ('SUBTICKET', 'HWR-{}'.format(hwr_order_id)),
                ('SUBTICKET_URL', 'https://hwr.yandex-team.ru/orders/{}'.format(hwr_order_id)),
                ('ID', hwr_order_id),
                ('ABC_SERVICE', full_abc_service_path),
                ('parent_project', ''),
                ('CAMPAIGN', campaign),
                ('GOAL_NAME', ''),
                ('GOAL_URL', ''),
                ('AUTHOR', row['Created by']),
                ('RESPONSIBLES', ''),
                ('HEAD_1', ''),
                ('HEAD_DEPARTMENT_1', head_department_1),
                ('HEAD_2', ''),
                ('HEAD_DEPARTMENT_2', head_department_2),
                ('HEAD_3', ''),
                ('HEAD_DEPARTMENT_3', head_department_3),
                ('JUSTIFICATION', ''),
                ('order_type', 'HWR_SERVER_ORDER'),
                ('STATUS', ''),
                ('SUMMARY', '{} servers, config: {}'.format(row['Count'], row['Configuration'])),
                ('Value Stream', ''),
                ('VS Manager', ''),
                ('VS Leader', ''),
                ('VS Capacity Planner', ''),
                ('BOT_PREORDER', ''),
                ('PROVIDER', 'hwr'),
                ('DC', ''),
                ('ABC_SERVICE_1', SERVICE_RENAMINGS.get(full_abc_components[0], full_abc_components[0]) if len(full_abc_components) > 0 else ''),
                ('ABC_SERVICE_2', SERVICE_RENAMINGS.get(full_abc_components[1], full_abc_components[1]) if len(full_abc_components) > 1 else ''),
                ('ABC_SERVICE_3', SERVICE_RENAMINGS.get(full_abc_components[2], full_abc_components[2]) if len(full_abc_components) > 2 else ''),
                ('ABC_SERVICE_4', SERVICE_RENAMINGS.get(full_abc_components[3], full_abc_components[3]) if len(full_abc_components) > 3 else ''),
                ('ABC_SERVICE_5', SERVICE_RENAMINGS.get(full_abc_components[4], full_abc_components[4]) if len(full_abc_components) > 4 else ''),
                ('ABC_SERVICE_6', SERVICE_RENAMINGS.get(full_abc_components[5], full_abc_components[5]) if len(full_abc_components) > 5 else ''),
                ('ABC_SERVICE_7', SERVICE_RENAMINGS.get(full_abc_components[6], full_abc_components[6]) if len(full_abc_components) > 6 else ''),
                ('ABC_SERVICE_8', SERVICE_RENAMINGS.get(full_abc_components[7], full_abc_components[7]) if len(full_abc_components) > 7 else ''),
                ('ABC_SERVICE_9', SERVICE_RENAMINGS.get(full_abc_components[8], full_abc_components[8]) if len(full_abc_components) > 8 else ''),
                ('ABC_SERVICE_10', SERVICE_RENAMINGS.get(full_abc_components[9], full_abc_components[9]) if len(full_abc_components) > 9 else ''),
            ]
        )

        if head_department_1 == 'Services of Experiments' and head_department_2 == 'Yandex.Cloud':
            cost = server_count * TCO_COST * 1.04
        else:
            cost = (configuration_cost * DOLLAR_PRICE / 48.0 + server_count * TCO_COST) * 1.04
        new_row['user_resources'] = [
            {
                'segment': 'default',
                'resource': 'u_hwr_server',
                'big_order': big_order,
                'unit': 'units',
                'val': server_count,
                'cost': cost,
            }
        ]
        out_data.append(new_row)

    return out_data
