import os
import copy
import json


COST_TARGETS = {}
COST_TARGETS_FILE_PATH = os.environ.get("COST_TARGETS", "")
if COST_TARGETS_FILE_PATH:
    with open(COST_TARGETS_FILE_PATH) as f:
        COST_TARGETS = json.loads(f.read())


def process_targets(targets, multiplier=1.0):
    """
    {
        "<business unit>": {
            "value": 1000.0,  # target value
            "vs": {
                "<value stream>": 100.0
            }
        }
    }
    """
    ans = copy.deepcopy(targets)
    for _, val in ans.items():
        val['value'] *= multiplier
    return ans
