# Процесс движения заявок

## Краткое описание {#short-description}

Процесс можно разбить на пять фаз:

- определение целей;
- сбор и подготовка к защите заявок;
- защита заявок внутри направления;
- сжатие заявок;
- защита на инфраструктурном и/или продуктовом комитетах.

Основные принципы:

- Основной инструмент сбора заявок сейчас - ABC, есть [инструкция](https://wiki.yandex-team.ru/intranet/abc/features/hardware/) о том, как использовать этот сервис для заказа квот.
- Все смены фаз сопровождаются нотификациями со стороны руководства процесса. К сожалению, не всегда возможно это делать заранее, т. к. время каждой фазы может меняться в зависимости от объема работы, который требуется для утверждения результатов предыдущих фаз.
- Периодических уведомлений о статусе не будет, но обновления по основным событиям внутри фаз будут (если будет о чем рассказать).

### Определение целей {#defining-goals}

В заявках, за некоторым исключением (на естественный рост), нужно будет указать цели, под которые нужна квота. Каждое направление должно само определить основные принципы целеполагания в отношении заявок на квоты. Про то, [как лучше выбрать цели](https://wiki.yandex-team.ru/intranet/abc/features/hardware/#goals) для заявок описано в документации по заказу. Цель этой фазы - быть готовым объяснять зачем нужен заказ (и подтвердить это целью).

### Сбор и подготовка к защите заявок {#collection-and-preparation}

На этой фазе собираются заявки. Пользователи [указывают сколько и в каких облаках](https://wiki.yandex-team.ru/intranet/abc/features/hardware/#create) им нужно ресурсов, [пишут обоснования](https://wiki.yandex-team.ru/intranet/abc/features/hardware/#review) для заявок под естественный рост своих сервисов и тех целей, под которые требуются новые ресурсы. Цель этой фазы - передать в ответственных за Capacity понятный им набор заявок для рассмотрения.

### Защита заявок внутри направления {#protection-of-applications}

[Проверка ответственными](https://wiki.yandex-team.ru/intranet/abc/features/hardware/#approve) за капасити направлений и утверждение. Финальный результат этой фазы - все заявки, которые нужны направлениям собраны в ABC, проверены по формальным критериям ответственными, достаточно оптимальны и хорошо обоснованы.

### Сжатие заявок {#compression-of-applications}

Когда становится известным бюджет на (до)закупку оборудования, начинается фаза сжатия заявок. Сжатие происходит с двух сторон: провайдеры что-то оптимизируют у себя, чтобы снизить стоимость квот, а направления - отказываются от целей или уменьшают свои запросы, планируя цели на оптимизацию. Результатом этой фазы должно стать попадание в бюджет.

### Защита на комитете(ах) {#protection}

Некоторые заявки, особенно крупные или противоречивые, попадут на комитеты: на рассмотрение к руководству. Цель этой фазы - верификация того, что мы закупаем оборудование под те цели и задачи, которые хорошо проработаны и следуют в конве развития компании.

## Роли в процессе {#roles}

**Capacity Planning Head** - [Дмитрий Нестеров](https://staff.yandex-team.ru/keyd). Руководит всем процессом.
**Department Committee** - внутренний комитет направления, где решаются вопросы целей и ресурсов, возглавляемый руководителем направления (или другим лицом, которому делегировано принятие продуктовых решений).
**User** - пользователь облаков (тот, кто заказывает ресурсы и обосновывает их количество).
**ABC** - наш инструмент автоматизации процесса.
**Capacity Manager (Responsible)** - ответственный за ресурсы направления.
**Passionate User** - небезразличный пользователь. Может прийти с вопросами.
**Capacity Planning Committee** - наш комитет.
**xxx Committee** - комитеты повыше.

## Схема процесса на текущий момент {#process-diagram}

Схему не очень удобно смотреть (она слишком большая, а делать ее динамической слишком трудоемко), есть пара советов по упрощению ее чтения:
- открыть в приложении, которое умеет смотреть и масштабировать SVG (подойдет обычный браузер);
- отталкиваться от своей роли. Так будет проще лично вам. Процесс для роли находится в горизонтальных "колбасках". Исходящие вертикальные стрелки - это то, где вы являетесь источником коммуникации с инструментом или коллегой. Входящие - приходят в вас. Горизонтальные - флоу внутри вашего процесса.

### Графическая схема {#graphic-scheme}

![campaign-process-current](https://s3.mds.yandex.net/doc-binary/src/arcadia/capacity-planning/Campaign-Process-current-r03.svg)


{% cut "Условные обозначения" %}

- Роли и процессы, на них завязанные, отображаются как большие горизонтальные колбасы.
- ![task](_images/task.png) - это задача. Внутри дано краткое описание того, что нужно делать на определенном этапе.
- Иконки внутри задачи можно игнорировать.
- Есть еще объекты данных, например, ![claim](_images/claim.png) или ![quota](_images/quota.png).
- ![call-from-st](_images/call-from-st.png) - определяет способ связи между ролями или что конкретно передается. Роли общаются только посредством "мессаджей", которые могут быть триггерами.
- ![mail](_images/mail.png) - каждый процесс начинается с триггера. Им может быть какое-то сообщение, календарь. Может быть несколько источников.
- ![condition](_images/condition.png) - условия или ветвления.

{% endcut %}

## Задачи по ролям для фаз сбора заявок {#tasks-by-roles}

### User {#users}

#### I. Фаза сбора заявок и подготовки к защите

На этой фазе пользователь проходит несколько этапов. При этом некоторые этапы может потребоваться пройти несколько раз (см. схему), например, после того, как Ответственный за ресурсы попросит что-то поправить.Процесс это фазы состоит из следующих этапов:

1. **Заполнение заявок** (на схеме: Create and Fill Quota Requests Out). [Делается](https://wiki.yandex-team.ru/intranet/abc/features/hardware/#new) в ABC. Нужно заполнить заявки на железо и описать как рассчитывался запрос.
2. **Редактирование заявок** (на схеме: Update Request). Этот этап выполняется, когда это необходимо (решили сами что-то исправить или кто-то попросил). На различных последующих этапах можно сюда вернуться для оптимизации. В редактировании есть [особенности](https://wiki.yandex-team.ru/intranet/abc/features/hardware/#edit) в автоматическом переключении статусов. За этим нужно следить.
3. [**Подготовка к защите заявок**](https://wiki.yandex-team.ru/intranet/abc/features/hardware/#review) (на схеме: Fill Request Goals / Organic Growth Info Out). Здесь ABC сгруппирует все заявки по целям или естественному росту. Нужно будет заполнить ответы на вопросы, относящиеся именно к целям или объяснить естественный рост.
4. **Исправление данных в формах подготовки к защите** (на схеме: Update Goals/Organic Growth Info). Требуется, если кто-то попросил или сами решили уточнить информацию по цели, для которой делается заказ ресурсов.
5. **Отправка заявок по цели/естественному росту на защиту** (на схеме: Submit Goals/Organic Growth for Review). Очень важный этап, без него заявки не начинают рассматриваться. Когда все заявки заполнены, вопросы к защите - тоже, нужно будет нажать на кнопочку, которая отправит заявки/цели дальше и установит статус готовности к защите. Кнопочка будет на экране подготовки к защите и статус она поменяет сразу у всех заявок естественного роста или цели. При каких-то изменениях в введенных ранее данных этот шаг нужно будет повторить.
6. **Проверка заявок с ответственным за ресурсы** (на схеме: Check Requests with Capacity Manager). После отправки заявок на ревью, нужно ждать к себе ответственного за Capacity направления и быть готовым обосновать заявку. Этот этап во всех направлениях может проходить по-разному. Если никаких изменений делать не потребуется, эта фаза для пользователя заканчивается. Иначе, придется обновить заявку или информацию для защиты и пройти все согласования заново (перепрыгнуть на более ранние этапы и повторить все последующие).

#### II. Фаза сокращения заявок

Эта фаза пока никак не автоматизирована в ABC. Ее задачи решаются в почте/тикетах и на встречах. На этой фазе есть единственный отдельный этап для пользователя:

1. **Анализ вопросов и подготовка ответов** (на схеме: Analyze & Answer the Questions). В процессе обсуждения бюджета и уплотнения заявок к вам придет ответственный за ресурсы направления и предложит оптимизировать заявки. Нужно будет придумать как это сделать, ответить на поступившие вопросы и запросы о корректировках заявок в соответствии с планом оптимизации. Соответственно, здесь может произойти возврат к этапам предыдущей фазы для редактирования и отмены заявок при необходимости (с повторением всех последующих этапов). Когда вопросы к пользователю заканчиваются, фазу можно считать закрытой.

### Capacity (Responsible) Manager {#capacity-manager}

#### I. Фаза сбора заявок и подготовки к защите

На этой фазе от управляющего ресурсами требуется рассмотреть заявки своего направления и принять по ним решения. Делается это, проходя по следующим этапам в цикле:
1. **Анализ** (на схеме: Analyze). С помощью интерфейса в ABC необходимо [прочитать и принять решение по заявкам](https://wiki.yandex-team.ru/intranet/abc/features/hardware/#approve).
2. **Вопросы, отзывы и возражения** (на схеме: Claim). При необходимости нужно дойти до пользователей с целью что-то обсудить (заявить претензии к расчетам и оформлению).
3. **Подтвердить** (на схеме: Confirm Requests) или **Отказать** (на схеме: Reject). Все обсуждения завершаются подтверждением или отказом как написано в инструкции к ABC.

#### II. Фаза сокращения заявок

Эта фаза пока никак не автоматизирована в ABC. Ее задачи решаются в почте/тикетах и на встречах.

1. **Начать обсуждение с руководством** (на схеме: Initiate Discussion at Department Level). После получения бюджетных целей нужно начать обсуждение на уровне направления что важнее, кого и каким образом нужно оптимизировать.
2. **Уведомить коллег о бюджетных целях** (на схеме: Notify about New Targets). Необходимо призвать пользователей в тикет (или иным образом) для обсуждения возможных действий для попадания в целевые значения.
3. **Фиксация обсуждений** (на схеме: Proceed Discussed Targets and Questions). Встречи с User, выставление им/их сервисам/голзам персональных таргетов на оптимизацию. Может потребоваться дополнительный анализ всех заявок, дополнительные уплотнения.

### Department Committee {#department-committee}

#### I. Фаза сбора заявок и подготовки к защите

На этом этапе участие уровня руководства направлений не предполагается.

#### II. Фаза сокращения заявок

Эта фаза пока никак не автоматизирована в ABC. Ее задачи решаются в почте/тикетах и на встречах. На уровне направления будет один этап на этой фазе, который, впрочем, может повторяться:

1. **Приоритизация** (на схеме: Discuss Targets, Prioritize Goals and Define Internal Targets by Service / Goal, Define new Questions). Обсуждение (если необходимо) с руководством направления приоритетов с целью определения от чего можно отказаться или что необходимо оптимизировать. Встречи собираются ответственным за ресурсы для обсуждения целей по оптимизации бюджета.

### Passionate User {#passionate-user}

#### I. Фаза сбора заявок и подготовки к защите

На этом этапе участие неравнодушных пользователей не предполагается. Приходите на этап компактификации. Если очень хочется - можно изучить заявки в ABC и прийти к ответственным за заявки или ресурсы в тикеты.

#### II. Фаза сокращения заявок

Эта фаза пока никак не автоматизирована в ABC. Ее задачи решаются в почте/тикетах и на встречах. На этой фазе становятся известны стоимостные характеристики заявок и топовые заказы. Можно прийти в их тикеты и что-то порекомендовать/задать вопросы:

1. **Add Questions for Reduction & Capacity Review** - небезразличные пользователи могут приходить и задавать вопросы или что-то советовать с целью оптимизации расхода ресурсов. Это могут быть провайдеры, например.

### Capacity Planning Head {#capacity-planning-head}

#### I. Фаза сбора заявок и подготовки к защите

1. **Announce the New Campaign Kick Off (at.y-t.ru, mail) - объявление, что кампания началась.** Делается через этушку и рассылку. Одновременно включается прием заявок в ABC.
2. **Support Colleagues and Process - поддержка процесса**. Команда управления ресурсами уровня компании помогает всем пользователя процесса на всем его протяжении.

#### II. Фаза сокращения заявок

Эта фаза пока никак не автоматизирована в ABC. Ее задачи решаются в почте/тикетах и на встречах.

1. **Finalize Preparation Phase and Start Reduction Phase (at.y-t.ru, mail) - завершение сбора заявок.** Руководитель процесса завершает фазу сбора, делая соответствующее объявление в рассылку и в этушке. Одновременно с этим он считает, сколько будут стоить собранные заявки для компании и обсуждает бюджеты.
2. **Define Company-Wide Targets - установка бюджетных целей.** Рано или поздно Митя придет и скажет, на сколько нужно будет уплотняться. Сделает это по почте или другими способами.

## Остались вопросы по процессу? {#faq}

Пишите нам ([Николаю Долганову](https://staff.yandex-team.ru/ndolganov)) или ([Дмитрию Нестерову](https://staff.yandex-team.ru/keyd)). Будем дополнять и уточнять описание процесса.