# Оформление заказа

## Жизненный цикл заказа ресурсов {#life-cycle}

Основной заказ на мощности собирается раз в год в августе в два этапа.

Сперва собираются заявки на ресурсы от проектов и проверяется из валидность.

Затем из этих заявок вычисляется сколько необходимо закупить серверов и сколько для этого понадобится денег.

Вкупе с другими капитальными расходами затраты на закупку серверов учитываются в [CAPEX](https://ru.wikipedia.org/wiki/Капитальные_расходы) бюджета на следующий год и согласуются с советом директоров.

Как правило, после согласования бюджет на закупку серверов получается меньше, чем требуется для удовлетворения всех заказов, поэтому часть заказов урезается, чтобы уложиться в бюджет.

По умолчанию, заказы выдаются тремя частями: в мае, августе и ноябре (см. [расписание](https://capacity-planning.daas.yandex-team.ru/timeline/index.html)).

Распределение заказа по частям определяется в процессе согласования заказа и после согласования не меняется.

## Дозаказы {#additional-orders}

В случае, если в серверном годовом бюджете остаётся резерв в деньгах, для сервисов, которые по уважительным причинам не смогли заказать мощности в основном заказе, есть возможность сделать дозаказ в феврале и июне. Уважительной причиной считается:

- непредвиденное изменение внешних условий, меняющих требования к сервису (например, непредвиденный рост трафика или новые требования от Роскомнадзора);
- появление нового сервиса, не ожидавшегося в момент сбора основного заказа.

Также, в феврале и июне, есть возможность изменить существующий ранее согласованный заказ в случае, если была совершена существенная ошибка при расчётах, а также указаны причины, почему эта ошибка была сделана, и указаны меры, которые были приняты, чтобы подобные ошибки больше не повторялись.

Если вы забыли или не успели подготовить заявку в срок, это не может являться основанием для включения сервиса в дозаказ.

## Правила работы с заявками {#working-with-applications}

Все заявки на ресурсы создаются в [системе сбора заявок](https://wiki.yandex-team.ru/Intranet/abc/features/hardware/#create).[Инструкция к системе сбора заявок](https://wiki.yandex-team.ru/Intranet/abc/features/hardware/)

По каждой заявке автоматически заводится тикет, в котором происходит обсуждение, сохраняется история всех договорённостей и финализируется заказ.

Каждая заявка должна быть согласована с ответственным за capapcity planning в вашем подразделении - [список ответственных за подразделения](https://wiki.yandex-team.ru/capacity-planning-comitee/).При отсутствии явного подтверждения заявка считается недействительной.

После финального согласования с руководителями, общее количество закупаемых ресурсов [может быть уменьшено](faq.md#why-the-order-was-cut).

## Правила подсчета ресурсов {#counting-resources}

Полезные инструкции по расчёту от провайдеров доступны [по ссылке](https://wiki.yandex-team.ru/Intranet/abc/features/hardware/#providers).

При подсчете ресурсов, требующихся сервису на новый период, выделяются 2 части:

- **Ресурсы на новую функциональность**. В эту часть входит подконтрольный рост потребления — новые фичи, эксперименты, маркетинговые активности и так далее. Если в процессе обсуждения заявки будет необходимо уменьшать заказ ресурсов, в первую очередь может быть уменьшена данная часть заказа.
- **Ресурсы на естественный рост**. В эту часть заявки входит неподконтрольный рост сервиса.

При подсчете ресурсов действует правило: чем подробнее и нагляднее приведена методика подсчета, тем быстрее происходит обсуждение заказа и тем меньше возникает дополнительных вопросов. Чтобы максимально понятно объяснить ваш заказ, приложите к заявке:

- Графики, показывающие текущую загрузку ресурсов. На графиках укажите тренд роста для следующего периода.
- Результаты нагрузочных испытаний. К результатам приложите описание того, что произойдет с сервисом при нехватке ресурсов.
- План по маркетинговым и продуктовым активностям на следующий период. Для всех крупных активностей укажите примерное требование к ресурсам.
- Если у сервиса есть KPI/SLA — приложите соответствующие графики, письменные договоренности и обоснование, как невыполнения этих KPI/SLA влияет на компанию.

## Примеры методик подсчета ресурсов {#examples-of-counting-techniques}

Ниже приведены методики, используемые в различных сервисах Яндекса:

{% cut "Морда" %}

Особых требований нет, всё обычно упирается в CPU:

1. Анализируется CTR каждого отдельного установленного на морде сервиса.
2. В зависимости от CTR считается RPS на каждый отдельный сервис.
3. Проводится обязательное нагрузочное тестирование сервисов и получается соотношение CTR/RPS к CPU.
4. Используется общий график роста аудитории Морды (или другого веб-сервиса). Скорость роста потребления CPU оценивается исходя из этого графика.
5. Заказы учитывают запас 10% на деградацию + 10% запаса под деплой + запас на отключение одного из трёх ДЦ.
6. Для новых сервисов оценка трафика происходит исходя из соображений, где он будет стоять на Морде (или другой дистрибуционной точке).

В Новостях (и, потенциально, в Мессенджере) есть специфичный кейс: иногда происходит крупное событие и нагрузка может превысить обычную в несколько раз. Сейчас под такие события держится запас. Размер запаса рассчитывается, исходя из исторических данных.

{% endcut %}

{% cut "Медиасервисы" %}

1. У менеджеров собирается предварительная оценка, во сколько раз будет расти сервис.
2. Исследуется тренд роста текущего RPS, делается прогноз роста на следующий год.
3. Прогноз роста RPS умножается на коэффициент, полученный от менеджеров.
4. По графикам потребления ресурсов вычисляется отношение потребления CPU/MEM/DISK к RPS.
5. Полученный прогноз по росту RPS с учётом коэффициента от менеджеров переводится в прогноз по росту CPU/MEM/DISK.
6. Заказывается дельта между прогнозным и текущим количеством ресурсов.
7. После поставки ресурсы отправляются в spare-пул, из которого вынимаются в нужный сервис по мере необходимости (исходя из предположения, что сервисы всегда утилизированы максимально и с учётом потенциального отключения одного ДЦ).
8. Для оценки, хватает ли ресурсов в данный момент, закрывается один ДЦ и исследуются тайминги. Если тайминги увеличились, то добавляется железо из spare-пула.

{% endcut %}

{% cut "Персональные сервисы" %}

Каждая из команд персональных сервисов:
1. Анализирует графики в Головане/Графане CPU/MEM/DISK: отдельно облака, отдельно железные машины (если они есть). Исследуется тренд роста добавляется небольшой запас.
2. Собирает продуктовые требования у руководителей — список запусков и анализ роста аудитории.
3. Делит дельту роста аудитории за год на дельту роста ресурсов по каждому сервис-провайдеру и получает коэффициент роста.
4. Умножает коэффициент роста на текущее количество ресурсов.

{% endcut %}