import time
from functools import wraps


def retry(f=None, exceptions=Exception, total_tries=5, initial_wait=1, backoff_factor=2):
    """
    Decorator for make retries
    :param exceptions: Exception(s), can be a tuple (Exception1, Exception2, ...)
    :param total_tries: total tries
    :param initial_wait: time to first retry
    :param backoff_factor: time multiplayer for next tries
    """
    def retry_decorator(f):
        @wraps(f)
        def func_with_retries(*args, **kwargs):
            _tries, _delay = total_tries + 1, initial_wait
            while _tries > 1:
                try:
                    return f(*args, **kwargs)
                except exceptions as e:
                    _tries -= 1
                    if _tries == 1:
                        print('Function: {} failed after {} tries.\n'.format(f.__name__, total_tries))
                        raise e
                    time.sleep(_delay)
                    _delay *= backoff_factor
        return func_with_retries

    if f and callable(f):
        return retry_decorator(f)
    else:
        def decorator(f):
            return retry_decorator(f)
        return decorator
