from operator import methodcaller


def create_table(client, path, schema=None, ignore_existing=True, force=False):
    schema = schema if schema else []
    columns = {
        'schema':
            [{'name': f[0], 'type': f[1]} for f in map(methodcaller('split', ':'), schema)]
    }
    client.create(
        'table', path,
        ignore_existing=ignore_existing,
        attributes=columns,
        force=force,
    )
