import argparse

from requests.exceptions import ConnectionError, ChunkedEncodingError

import yt.wrapper as yt
from infra.capacity_planning.library.python import abc_tree
from infra.capacity_planning.library.python.base import retry
from infra.capacity_planning.library.python.yt_tables import create_table


@retry(exceptions=(ConnectionError, ChunkedEncodingError, ConnectionResetError))
def get_data(token):
    data = []
    abc_api_holder = abc_tree.load_abc_api(token=token, reload=False)
    for row in abc_api_holder.service_tree.values():
        vs_or_top_id = abc_api_holder.get_service_vs_or_top_id(service_id=row['id'])
        vs_or_top = abc_api_holder.service_tree[vs_or_top_id]
        data.append({
            'id': row['id'],
            'name': row['name'],
            'slug': row['slug'],
            'children': ','.join(map(str, row['children'])),
            'parents': ','.join(map(str, row['parents'])),
            'vs_id': vs_or_top['id'],
            'vs_slug': vs_or_top['slug'],
            'vs_name': vs_or_top['name'],
        })
    return data


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--token', default=None)
    return parser.parse_args()


def main():
    args = parse_args()

    data = get_data(args.token)
    yt_path = '//home/capacity_planning/abc_tree/current'
    yt_client = yt.YtClient('hahn')
    schema = [
        'id:int64',
        'name:string',
        'slug:string',
        'children:string',
        'parents:string',
        'vs_id:int64',
        'vs_slug:string',
        'vs_name:string',
    ]
    create_table(client=yt_client, path=yt_path, schema=schema)
    yt_client.write_table(yt_path, data)
