import time
from collections import OrderedDict
import json
import subprocess

from infra.capacity_planning.utils.hardware_utilization.lib.yt_tables import get_tariff, create_table
import yt.wrapper as yt


def collect_and_put(client, path):
    """
    Collect data from yp
    :return: dict, data
    """
    result = []
    now = int(time.mktime(time.strptime(time.strftime('%Y %m %d %H %M'), '%Y %m %d %H %M')))

    tariff = get_tariff(client)

    for dc in ('iva', 'vla', 'man', 'sas'):
        for segment in ('gpu-default', 'gpu-dev'):
            command = 'ya tool yp get node_segment {0} --selector /status ' \
                      '--format json --address {1}'.format(segment, dc)
            data = json.loads(subprocess.check_output(command, shell=True))
            cards_us = data[0]['used_resources']['gpu_per_model']
            cards_sh = data[0]['schedulable_resources']['gpu_per_model']
            for gpu_type, values in cards_sh.items():
                row = OrderedDict()
                row['date'] = now
                row['dc'] = dc
                row['segment'] = segment
                row['gpu_type'] = gpu_type
                row['schedulable_resources'] = values['capacity']
                row['used_resources'] = cards_us[gpu_type]['capacity']
                row['not_used_resources'] = row['schedulable_resources'] - row['used_resources']
                billing = tariff[gpu_type]
                row['billing'] = billing
                row['money_per_hour'] = billing / 30 / 24 * row['not_used_resources']
                if row:
                    result.append(row)

    client.write_table(path, result)


def main():
    cluster = 'hahn'
    yt_client = yt.YtClient(cluster)
    path = '<append=true>//home/capacity_planning/gpu_idle/not_used_res'
    schema = [
        'date:datetime',
        'dc:string',
        'segment:string',
        'gpu_type:string',
        'schedulable_resources:int64',
        'used_resources:int64',
        'not_used_resources:int64',
        'billing:double',
        'money_per_hour:double',
    ]
    create_table(client=yt_client, path=path, schema=schema)
    collect_and_put(yt_client, path)


if __name__ == '__main__':
    main()
