import time
from infra.capacity_planning.utils.hardware_utilization.lib.yt_tables import get_tariff, create_table
from infra.capacity_planning.utils.hardware_utilization.lib.golovan import golovan_request
import yt.wrapper as yt
import math


def collect_and_put(yt_client, yt_path, billing):
    one_hour = 3600
    end_time = int(time.mktime(time.strptime(time.strftime("%Y %m %d"), "%Y %m %d"))) - one_hour
    start_time = int(end_time) - 23 * one_hour
    signal = 'itype=runtimecloud:push-gpustat-gpu_stuck_count_tmmv'
    host = 'ASEARCH'
    req = golovan_request(host=host, period=one_hour, signals=[signal], start_time=start_time, end_time=end_time)
    result = []
    for data in req:
        row = dict()
        row['date'] = data[0]
        gpu_stuck_count = data[1][signal]
        row['gpu_stuck_count'] = math.floor(gpu_stuck_count)
        row['billing'] = billing['gpu_tesla_a100']
        row['money_per_hour'] = row['gpu_stuck_count'] * row['billing'] / 30 / 24
        result.append(row)

    yt_client.write_table(yt_path, result)


def main():
    cluster = 'hahn'
    yt_path = '<append=true>//home/capacity_planning/gpu_idle/gpu_stuck'
    yt_client = yt.YtClient(cluster)
    billing = get_tariff(yt_client)
    schema = [
        'date:datetime',
        'gpu_stuck_count:int64',
        'billing:double',
        'money_per_hour:double',
    ]
    create_table(client=yt_client, path=yt_path, schema=schema)
    collect_and_put(yt_client, yt_path, billing)


if __name__ == '__main__':
    main()
