from infra.yasm.yasmapi import GolovanRequest
import time


def golovan_request(host, period, start_time, end_time, signals: list[str]):
    max_tries = 5
    for n_try in range(max_tries):
        try:
            return list(GolovanRequest(host, period, start_time, end_time, signals))
        except Exception as e:
            if n_try < max_tries - 1:
                time.sleep(3 * (n_try + 1))
                continue
            raise e
