from collections import defaultdict
from operator import methodcaller


def create_table(client, path, schema=None, ignore_existing=True, force=False):
    schema = schema if schema else []
    columns = {
        'schema':
            [{'name': f[0], 'type': f[1]} for f in map(methodcaller('split', ':'), schema)]
    }
    client.create(
        'table', path,
        ignore_existing=ignore_existing,
        attributes=columns,
        force=force,
    )


def get_tariff(client):
    """
    Get billings from Yt table
    :param client: YT client
    :return: dict[gpu_card]: billing
    """
    table = '//home/capacity_planning/gpu_idle/billing'
    tariff = defaultdict(float)
    skus = {
        'yp.gpu_tesla_v100.quota': ['gpu_tesla_v100_nvlink', 'gpu_tesla_v100'],
        'yp.gpu_geforce_1080ti.quota': ['gpu_geforce_1080ti'],
        'yp.gpu_tesla_k40.quota': ['gpu_tesla_k40'],
        'yp.gpu_tesla_m40.quota': ['gpu_tesla_m40'],
        'yt.hahn.gpu.tesla_a100.strong_guarantee.gpu': ['gpu_tesla_a100'],
        'yt.hahn.gpu.tesla_a100.usage.gpu': ['gpu_tesla_a100'],
        'yt.hahn.gpu.tesla_a100_80g.strong_guarantee.gpu': ['gpu_tesla_a100_80g'],
        'yt.hahn.gpu.tesla_a100_80g.usage.gpu': ['gpu_tesla_a100_80g'],
    }
    for row in client.read_table(client.TablePath(table)):
        sku = row['name']
        for card in skus.get(sku, []):
            tariff[card] += row['unit_price']
    return tariff
