from infra.capacity_planning.utils.quota_transfer_statistics.lib.get_data_from_queue import file_name
import json
from collections import defaultdict

skip = f'\n{"*" * 50}\n'
SEGMENTS = ('default', 'dev', 'gpu-default', 'gpu-dev')


class Yp:
    def __init__(self):
        self.len = 0
        self.counter = defaultdict(lambda: defaultdict(lambda: defaultdict(lambda: defaultdict(int))))
        self.dc_pattern = defaultdict(lambda: defaultdict(int))
        self.res_pattern = defaultdict(lambda: defaultdict(int))

    def add(self, result, folder):
        self.len += 1
        pattern_res = set()
        dc_pattern = set()
        for resource in result['resource']:
            pattern_res.add(resource['name'])
            dc_pattern.add((resource['dc']))
            self.counter[folder][resource['segment']][resource['dc']][resource['name']] += 1
        pattern_res = tuple(sorted(pattern_res))
        self.res_pattern[folder][pattern_res] += 1
        dc_pattern = tuple(sorted(dc_pattern))
        self.dc_pattern[folder][dc_pattern] += 1

    def write(self, f, folder):
        f.write('Распределение по YP:\n\n')
        dc_count = defaultdict(int)
        for segment in SEGMENTS:
            for dc in self.counter[folder][segment]:
                for value in self.counter[folder][segment][dc].values():
                    dc_count[dc] += value
        write_values(f, header='Дц по заявкам:\n', def_dict=dc_count)
        write_values(
            f, header='\nСамые частые паттерны по дц в одной заявке:\n',
            def_dict=self.dc_pattern[folder], top=10
        )
        res_count = defaultdict(int)
        for segment in SEGMENTS:
            for dc in self.counter[folder][segment]:
                for name, value in self.counter[folder][segment][dc].items():
                    res_count[name] += value
        write_values(f, header='\nРесурсы по заявкам:\n', def_dict=res_count, top=10)
        write_values(
            f, header='\nСамые частые паттерны ресурсов в одной заявке:\n',
            def_dict=self.res_pattern[folder], top=10
        )

        seg_counter = defaultdict(int)
        for segment in SEGMENTS:
            for dc in self.counter[folder][segment]:
                for value in self.counter[folder][segment][dc].values():
                    seg_counter[segment] += value

        write_values(f, header='\nРаспределение по сегментам YP:\n', def_dict=seg_counter)
        for segment in SEGMENTS:
            dc_count = defaultdict(int)
            for dc in self.counter[folder][segment]:
                for value in self.counter[folder][segment][dc].values():
                    dc_count[dc] += value
            write_values(f, header=f'Дц по заявкам в {segment}:\n', def_dict=dc_count)

            res_count = defaultdict(int)
            for dc in self.counter[folder][segment]:
                for name, value in self.counter[folder][segment][dc].items():
                    res_count[name] += value
            write_values(f, header=f'\nРесурсы по по заявкам в {segment}:\n', def_dict=res_count, top=10)


class Yt:
    def __init__(self):
        self.len = 0
        self.counter = defaultdict(lambda: defaultdict(lambda: defaultdict(int)))
        self.cluster_pattern = defaultdict(lambda: defaultdict(int))
        self.res_pattern = defaultdict(lambda: defaultdict(int))

    def add(self, result, folder):
        self.len += 1
        pattern_res = set()
        cluster_pattern = set()
        for resource in result['resource']:
            pattern_res.add(resource['name'])
            cluster_pattern.add((resource['cluster']))
            self.counter[folder][resource['cluster']][resource['name']] += 1
        pattern_res = tuple(sorted(pattern_res))
        self.res_pattern[folder][pattern_res] += 1
        cluster_pattern = tuple(sorted(cluster_pattern))
        self.cluster_pattern[folder][cluster_pattern] += 1

    def write(self, f, folder):
        f.write('\nСтатистика по YT:\n\n')
        cluster_count = defaultdict(int)
        for cluster in self.counter[folder]:
            for value in self.counter[folder][cluster].values():
                cluster_count[cluster] += value
        write_values(f, header='Кластеры по заявкам:\n', def_dict=cluster_count)
        write_values(
            f, header='\nСамые частые паттерны по кластерам в одной заявке:\n',
            def_dict=self.cluster_pattern[folder], top=10
        )
        res_counter = defaultdict(int)
        for cluster in self.counter[folder]:
            for name, value in self.counter[folder][cluster].items():
                res_counter[name] += value
        write_values(
            f, header='\nРесурсы по по заявкам:\n',
            def_dict=res_counter, top=10
        )
        write_values(
            f, header='\nСамые частые паттерны ресурсов в одной заявке:\n',
            def_dict=self.res_pattern[folder], top=10
        )


class Sandbox:
    def __init__(self):
        self.len = 0
        self.counter = defaultdict(lambda: defaultdict(int))
        self.res_pattern = defaultdict(lambda: defaultdict(int))

    def add(self, result, folder):
        self.len += 1
        pattern_res = set()
        for resource in result['resource']:
            pattern_res.add(resource['name'])
            self.counter[folder][resource['name']] += 1
        pattern_res = tuple(sorted(pattern_res))
        self.res_pattern[folder][pattern_res] += 1

    def write(self, f, folder):
        f.write('\nСтатистика по Sandbox:\n')
        write_values(
            f, header='\nРесурсы по по заявкам:\n',
            def_dict=self.counter[folder], top=10
        )
        write_values(
            f, header='\nСамые частые паттерны ресурсов в одной заявке:\n',
            def_dict=self.res_pattern[folder], top=10
        )


def write_values(f, def_dict, header=None, top=None):
    if header:
        f.write(header)
    sum_ = sum(def_dict.values())
    i = 0
    for name, val in sorted(def_dict.items(), key=lambda x: x[1], reverse=True):
        f.write(f'{name}: {val} ({val / sum_ * 100:.2f} %)\n')
        i += 1
        if top and i == top:
            break
    f.write(skip)


def analytics():
    yp = Yp()
    yt = Yt()
    sandbox = Sandbox()
    provider_count = defaultdict(lambda: defaultdict(int))
    with open(file_name, 'r') as f:
        data = json.load(f)
        for issue in data:
            folder = 'default' if issue['folder_from'] == issue['folder_to'] == 'default' else 'reserve'

            for result in issue['result']:
                provider = result['provider']
                provider_count[folder][provider] += 1

                if provider == "YP":
                    yp.add(result, folder)
                if provider == "YT":
                    yt.add(result, folder)
                if provider == "Sandbox":
                    sandbox.add(result, folder)

    with open('statistic_test.txt', 'w') as f:
        f.write(f'Тикетов в очереди: {len(data)}{skip}')
        for folder in ('default', 'reserve'):
            f.write(f'Переносов между {folder} фолдерами - {sum(provider_count[folder].values())}\n')
        for folder in ('default', 'reserve'):
            f.write(f'\nСтатистика по {folder}:\n\n')
            providers = provider_count[folder]
            write_values(f, header='Распределение по провайдерам:\n', def_dict=providers)
            if yp.len > 0:
                yp.write(f, folder)
            if yt.len > 0:
                yt.write(f, folder)
            if sandbox.len > 0:
                sandbox.write(f, folder)
    print('Статистика загружена в файл statistic.txt')
