from startrek_client import Startrek
import json
import datetime

file_name = 'result.json'


def str_to_num(str_):
    if '.' in str_ and str_.replace('.', '').isdigit():
        return float(str_)
    elif str_.isdigit():
        return int(str_)


def get_folder(issue):
    # пример строки
    # 'Перенос квоты из yp:reserve в marketyp:default'
    summary = issue['summary'].split(' ')
    folders = [word.split(':')[-1] for word in summary if ':' in word]
    folder_from = folders[0] if len(folders) > 0 else None
    folder_to = folders[1] if len(folders) > 1 else None
    return folder_from, folder_to


def get_resource_data(lst):
    result = dict()
    result['provider'] = lst[0].split(':')[1].removesuffix('**').strip()
    result['resource'] = []
    provider = result['provider'].lower()
    for i in range(1, len(lst)):
        # MAN default Объём SSD: 20 TiB
        # пример строки lst[i]
        provider_info, number_unit = lst[i].rsplit(':', maxsplit=1)
        number, unit = number_unit.split()
        row = {
            'value': {
                'number': str_to_num(number),
                'unit': unit,
            }
        }
        provider_info = provider_info.split()
        dc, cluster, segment, name = None, None, None, None
        if provider == 'yp':
            # ['VLA', 'default', 'CPU']
            dc = provider_info[0]
            segment = provider_info[1]
            name = ' '.join(provider_info[2:])

        elif provider == 'yt':
            # ['Hahn', 'количество', 'нод']
            cluster = provider_info[0]
            name = ' '.join(provider_info[1:])

        elif provider == 'yp prestable':
            # ['SAS', 'TEST', 'default', 'RAM']
            dc = '{}_{}'.format(provider_info[0], provider_info[1])
            segment = provider_info[2]
            name = ' '.join(provider_info[3:])

        elif result['provider'].lower() == 'saas':
            # ['HDD', 'MAN']
            dc = provider_info[1]
            name = provider_info[0]
        else:
            name = provider_info[0]
        row.update(
            {
                'dc': dc,
                'cluster': cluster,
                'segment': segment,
                'name': name,
            }
        )
        result['resource'].append(row)
    return result


def get_data_from_description(description):
    result = []
    blocks = [f for f in description.split('\n\n') if '**Провайдер:' in f]
    row_blocks = []
    current_block = []
    for block in blocks:
        for row in block.split('\n'):
            if row.startswith('**Провайдер:'):
                current_block = []
                row_blocks.append(current_block)
            current_block.append(row)

    for row_block in row_blocks:
        result.append(get_resource_data(row_block))
    return result


def get_data(user, token, start_date=None, end_date=None):
    client = Startrek(useragent=user, token=token)
    issues = client.issues.find(filter={'queue': 'DISPENSERTREQ'})
    result = []
    for issue in issues:
        created_at = datetime.datetime.strptime(issue['createdAt'], '%Y-%m-%dT%H:%M:%S.%f+0000')
        if start_date and start_date > created_at:
            continue
        if end_date and end_date < created_at:
            continue
        folder_from, folder_to = get_folder(issue)
        row = {
            'key': issue['key'],
            'author': issue['createdBy'].login,
            'folder_from': folder_from,
            'folder_to': folder_to,
            'result': get_data_from_description(issue['description']),
            'created_at': issue['createdAt']
        }
        result.append(row)
    with open(file_name, 'w') as f:
        json.dump(result, f, indent=4, ensure_ascii=False)

    print(f'Тикетов в очереди: {len(result)}\nДанные загружены в файл {file_name}')
