import argparse
import datetime
from infra.capacity_planning.utils.quota_transfer_statistics.lib.get_data_from_queue import get_data
from infra.capacity_planning.utils.quota_transfer_statistics.lib.analytics import analytics
import os
import sys
import getpass


def get_token():
    token_path = os.path.expanduser('~/.abc/token')
    if not os.path.exists(token_path):
        sys.stderr.write(
            'NO TOKEN found at ~/.abc/token\n'
            'get it at '
            'https://oauth.yandex-team.ru/authorize?response_type=token&client_id=5f671d781aca402ab7460fde4050267b\n'
        )
        exit(1)
    with open(token_path) as f:
        return f.read().strip()


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--token', type=str, default=None)
    parser.add_argument('--last-months', type=int, default=None)
    parser.add_argument('--start-date', type=str, default=None)
    parser.add_argument('--end-date', type=str, default=None)
    parser.add_argument('--login', type=str, default=None)
    args = parser.parse_args()
    user = args.login or getpass.getuser()
    token = args.token
    if not token:
        token = get_token()
    start_date = args.start_date
    if start_date:
        start_date = datetime.datetime.strptime(start_date, '%d.%m.%Y')
    end_date = args.end_date
    if end_date:
        end_date = datetime.datetime.strptime(end_date, '%d.%m.%Y')
    last_months = args.last_months
    if last_months:
        start_date = datetime.datetime.now() - datetime.timedelta(days=30*last_months)

    get_data(user, token, start_date=start_date, end_date=end_date)
    analytics()


if __name__ == '__main__':
    main()
