"""
Collect diff qloud data from table in another location with union in one table and strict sheme for datalens
"""

import yt.wrapper as yt
from collections import OrderedDict
from infra.capacity_planning.library.python.yt_tables import create_table

reserve_groups = ["MSK_RESERVED",
                  "VLA_RESERVED",
                  "SAS_RESERVED",
                  "MAN_RESERVED",
                  "RESERVE_SELECTED",
                  "RESERVE_UPDATE",
                  "RESERVE_BAD"]

dynamic_groups = ["ALL_DYNAMIC",
                  "ALL_PERSONAL",
                  "ALL_SOX"]

reserve = reserve_groups + dynamic_groups
capacity_tables = ['//home/capacity_planning/reserves/capacity/qloud/qloud',
                   '//home/capacity_planning/reserves/gencfg/gencfg_add',
                   '//home/capacity_planning/reserves/capacity/yp/yp_add']


def collect_cap(yt_client, yt_root_path):
    for name in capacity_tables:
        if 'gencfg' in name:
            yt_root_path = '<append=true>' + yt_root_path
        table = yt_client.read_table(name)
        data = []
        for line in table:
            flag = 0
            for elem in data:
                if 'qloud' in name:
                    date = line["data"]
                elif 'gencfg' in name:
                    date = line["date"]
                elif 'yp' in name:
                    date = line["Data"]
                if elem["data"] == date and elem["dc"] == line["dc"].lower():
                    elem["cpu"] += float(line["cpu"])
                    elem["memory"] += float(line["memory"])
                    flag = 1
                    break
            if not flag:
                row = OrderedDict()
                if 'qloud' in name:
                    row["data"] = line["data"]
                    row["cloud"] = "qloud"
                    row["name"] = "qloud capacity"
                elif 'gencfg' in name:
                    row["data"] = line["date"]
                    row["cloud"] = "gencfg"
                    row["name"] = "gencfg capacity"
                elif 'yp' in name:
                    row["data"] = line["Data"]
                    row["cloud"] = "yp"
                    row["name"] = "yp capacity"
                row["dc"] = line["dc"].lower()
                row["cpu"] = float(line["cpu"])
                row["memory"] = float(line["memory"])
                row["type"] = "capacity"
                data.append(row)
        yt_client.write_table(yt_root_path, data)


quota_tables = ['//home/capacity_planning/reserves/quotas/qloud/qloud',
                '//home/capacity_planning/reserves/quotas/yp/yp', '//home/capacity_planning/reserves/gencfg/gencfg_add']


def collect_qout(yt_client, yt_root_path):
    for name in quota_tables:
        table = yt_client.read_table(name)
        data = []
        for line in table:
            if 'yp' in name:
                if not(line["segment"] in ('dbaas', 'default', 'dev', 'distbuild', 'gpu-default', 'gpu-dev',
                                           'help') and line["quota_type"] == "total_quota" and line["geo"] in ('iva', 'man', 'myt', 'sas', 'vla')):
                    continue
            if 'gencfg' in name:
                if line["group_name"] in reserve:
                    continue
            flag = 0
            for elem in data:
                if 'qloud' in name:
                    date = line["data"]
                    dc = line["dc"].lower()
                elif 'yp' in name:
                    date = line["date"]
                    dc = line["geo"].lower()
                elif 'gencfg' in name:
                    date = line["date"]
                    dc = line["dc"].lower()
                if elem["data"] == date and elem["dc"] == dc:
                    if 'yp' in name:
                        elem["cpu"] += float(line["vcpu"]) / 1000
                    else:
                        elem["cpu"] += float(line["cpu"])
                    elem["memory"] += float(line["memory"])
                    flag = 1
                    break
            if not flag:
                row = OrderedDict()
                if 'qloud' in name:
                    row["data"] = line["data"]
                    row["cloud"] = "qloud"
                    row["name"] = "qloud quota"
                    row["cpu"] = float(line["cpu"])
                    row["dc"] = line["dc"].lower()
                elif 'yp' in name:
                    row["data"] = line["date"]
                    row["cloud"] = "yp"
                    row["name"] = "yp quota"
                    row["cpu"] = float(line["vcpu"]) / 1000
                    row["dc"] = line["geo"].lower()
                elif 'gencfg' in name:
                    row["data"] = line["date"]
                    row["cloud"] = "gencfg"
                    row["name"] = "gencfg quota"
                    row["cpu"] = float(line["cpu"])
                    row["dc"] = line["dc"].lower()
                row["memory"] = float(line["memory"])
                row["type"] = "quota"
                data.append(row)
        yt_client.write_table(yt_root_path, data)


def collect_qloud_diff(yt_client, yt_root_path):
    table = yt_client.read_table('//home/capacity_planning/reserves/capacity/qloud/qloud')
    data = []
    for line in table:
        flag = 0
        for elem in data:
            if elem["data"] == line["data"] and elem["dc"] == line["dc"].lower():
                elem["cpu"] += float(line["cpu"])
                elem["memory"] += float(line["memory"])
                flag = 1
                break
        if not flag:
            row = OrderedDict()
            row["data"] = line["data"]
            row["cloud"] = "qloud"
            row["name"] = "qloud diff"
            row["dc"] = line["dc"].lower()
            row["cpu"] = float(line["cpu"])
            row["memory"] = float(line["memory"])
            row["type"] = "diff"
            data.append(row)

    table = yt_client.read_table('//home/capacity_planning/reserves/quotas/qloud/qloud')
    for line in table:
        flag = 0
        for elem in data:
            if elem["data"] == line["data"] and elem["dc"] == line["dc"].lower():
                elem["cpu"] -= float(line["cpu"])
                elem["memory"] -= float(line["memory"])
                flag = 1
                break
        if not flag:
            row = OrderedDict()
            row["data"] = line["data"]
            row["cloud"] = "qloud"
            row["name"] = "qloud diff"
            row["dc"] = line["dc"].lower()
            row["cpu"] = -float(line["cpu"])
            row["memory"] = -float(line["memory"])
            row["type"] = "diff"
            data.append(row)
    yt_client.write_table(yt_root_path, data)


def collect_yp_diff(yt_client, yt_root_path):
    table = yt_client.read_table('//home/capacity_planning/reserves/capacity/yp/yp_add')
    data = []
    for line in table:
        flag = 0
        for elem in data:
            if elem["data"] == line["Data"] and elem["dc"] == line["dc"].lower():
                elem["cpu"] += float(line["cpu"])
                elem["memory"] += float(line["memory"])
                flag = 1
                break
        if not flag:
            row = OrderedDict()
            row["data"] = line["Data"]
            row["cloud"] = "yp"
            row["name"] = "yp diff"
            row["dc"] = line["dc"].lower()
            row["cpu"] = float(line["cpu"])
            row["memory"] = float(line["memory"])
            row["type"] = "diff"
            data.append(row)

    table = yt_client.read_table('//home/capacity_planning/reserves/quotas/yp/yp')
    for line in table:
        if line["segment"] in ('dbaas', 'default', 'dev', 'distbuild', 'gpu-default', 'gpu-dev',
                               'help') and line["quota_type"] == "total_quota" and line["geo"] in ('iva', 'man', 'myt', 'sas', 'vla'):
            flag = 0
            for elem in data:
                if elem["data"] == line["date"] and elem["dc"] == line["geo"].lower():
                    elem["cpu"] -= float(line["vcpu"]) / 1000
                    elem["memory"] -= float(line["memory"])
                    flag = 1
                    break
            if not flag:
                row = OrderedDict()
                row["data"] = line["date"]
                row["cloud"] = "yp"
                row["name"] = "yp diff"
                row["dc"] = line["geo"].lower()
                row["cpu"] = -float(line["vcpu"]) / 1000
                row["memory"] = -float(line["memory"])
                row["type"] = "diff"
                data.append(row)
    yt_client.write_table(yt_root_path, data)


def collect_gencfg_diff(yt_client, yt_root_path):
    table = yt_client.read_table('//home/capacity_planning/reserves/gencfg/gencfg_add')
    data = []
    for line in table:
        if line["group_name"] in reserve:
            flag = 0
            for elem in data:
                if elem["data"] == line["date"] and elem["dc"] == line["dc"].lower():
                    elem["cpu"] += float(line["cpu"])
                    elem["memory"] += float(line["memory"])
                    flag = 1
                    break
            if not flag:
                row = OrderedDict()
                row["data"] = line["date"]
                row["cloud"] = "gencfg"
                row["name"] = "gencfg diff"
                row["dc"] = line["dc"].lower()
                row["cpu"] = float(line["cpu"])
                row["memory"] = float(line["memory"])
                row["type"] = "diff"
                data.append(row)
    yt_client.write_table(yt_root_path, data)


def main():
    cluster = 'hahn'
    yt_client = yt.YtClient(cluster)
    schema = [
        "data:datetime",
        "cloud:string",
        "type:string",
        "dc:string",
        "name:string",
        "cpu:double",
        "memory:double",
    ]
    yt_root_path = '//home/capacity_planning/reserves/diff/all'
    create_table(client=yt_client, path=yt_root_path, schema=schema)

    collect_cap(yt_client, yt_root_path)
    yt_root_path = '<append=true>' + yt_root_path
    collect_qout(yt_client, yt_root_path)
    collect_qloud_diff(yt_client, yt_root_path)
    collect_yp_diff(yt_client, yt_root_path)
    collect_gencfg_diff(yt_client, yt_root_path)
