"""
Collect gencfg data from table in another location with union in one table and strict sheme for datalens
"""

import yt.wrapper as yt
from collections import OrderedDict
from datetime import date
import time

CLUSTER = 'hahn'
YT_PATH = '<append=true>//home/capacity_planning/reserves/gencfg/gencfg_add'
yt_client = yt.YtClient(CLUSTER)


def create_table():
    """
    Create table in YT
    :return: None
    """
    yt_client.create("table", YT_PATH,
                     ignore_existing=True,
                     attributes={
                         "schema":
                             [
                                 {"name": "date", "type": "datetime"},
                                 {"name": "account_id", "type": "string"},
                                 {"name": "cpu", "type": "int64"},
                                 {"name": "dc", "type": "string"},
                                 {"name": "group_name", "type": "string"},
                                 {"name": "hdd_storage", "type": "int64"},
                                 {"name": "is_rtc_group", "type": "boolean"},
                                 {"name": "memory", "type": "int64"},
                                 {"name": "ssd_storage", "type": "int64"},
                             ]
                     }
                     )


def collect():
    create_table()
    today = date.today().strftime("%Y-%m-%d")
    table = yt_client.read_table('//home/data_com/cubes/gencfg/groups_data/{}'.format(today))
    data = []
    datatime = time.mktime(time.strptime(today, "%Y-%m-%d"))
    for line in table:
        row = OrderedDict()
        row["date"] = int(datatime)
        row["account_id"] = line["account_id"]
        row["cpu"] = line["cpu"]
        row["dc"] = line["dc"]
        row["group_name"] = line["group_name"]
        row["hdd_storage"] = line["hdd_storage"]
        row["is_rtc_group"] = line["is_rtc_group"]
        row["memory"] = line["memory"]
        row["ssd_storage"] = line["ssd_storage"]
        data.append(row)
    yt_client.write_table(YT_PATH, data)


def main():
    collect()
