"""
Collect data about qloud migrations
"""

import requests
import time
from collections import OrderedDict
from datetime import date

import yt.wrapper as yt
from infra.capacity_planning.library.python.base import retry

CLUSTER = 'hahn'
YT_PATH = '<append=true>//home/capacity_planning/reserves/migrations/qloud/qloud'
yt_client = yt.YtClient(CLUSTER)


def create_table():
    """
    Creating table in YT
    :return: None
    """
    yt_client.create("table", YT_PATH,
                     ignore_existing=True,
                     attributes={
                         "schema":
                             [
                                 {"name": "data", "type": "datetime"},
                                 {"name": "qloud-env", "type": "string"},
                                 {"name": "abc", "type": "int64"},
                                 {"name": "memory", "type": "double"},
                                 {"name": "hdd", "type": "double"},
                                 {"name": "cpu", "type": "double"},
                                 {"name": "ssd", "type": "double"},
                                 {"name": "ipv4", "type": "double"},
                                 {"name": "qloud-segment", "type": "string"},
                                 {"name": "cluster", "type": "string"},
                                 {"name": "qloud-project", "type": "string"},
                             ]
                     }
                     )


@retry
def get_data():
    data = requests.get('https://yp-quota-distributor.n.yandex-team.ru/qloud/stats/', verify=False)
    return data.json()


def parse_data(data):
    """
    Format data from migrator
    :return: formatted data
    """
    result = []
    datatime = time.mktime(time.strptime(str(date.today()), "%Y-%m-%d"))
    for line in data["openMigrations"]:
        row = OrderedDict()
        row["data"] = int(datatime)
        row["qloud-env"] = line["qloud-env"]
        row["abc"] = line["abc"]
        row["memory"] = line["quota"]["memory"]
        row["hdd"] = line["quota"]["hdd"]
        row["cpu"] = line["quota"]["cpu"]
        row["ssd"] = line["quota"]["ssd"]
        row["ipv4"] = float(line["quota"]["ipv4"])
        row["qloud-segment"] = line["qloud-segment"]
        row["cluster"] = line["cluster"]
        row["qloud-project"] = line["qloud-project"]
        result.append(row)
    return result


def main():
    create_table()
    data = get_data()
    result = parse_data(data)
    yt_client.write_table(YT_PATH, result)
