"""
Collect data with strict sheme for datalens + union with date field in one table
"""

import yt.wrapper as yt
import time
from datetime import date

CLUSTER = 'hahn'
YT_PATH = '<append=true>//home/capacity_planning/reserves/quotas/yp/yp'
yt_client = yt.YtClient(CLUSTER)


def create_table():
    """
    Creating table for YT.
    :return: None
    """
    yt_client.create("table", YT_PATH,
                     ignore_existing=True,
                     attributes={
                         "schema":
                             [
                                 {"name": "date", "type": "datetime"},
                                 {"name": "geo", "type": "string"},
                                 {"name": "account_id", "type": "string"},
                                 {"name": "segment", "type": "string"},
                                 {"name": "hdd_bandwidth", "type": "int64"},
                                 {"name": "hdd_storage", "type": "int64"},
                                 {"name": "memory", "type": "int64"},
                                 {"name": "net_bandwidth", "type": "int64"},
                                 {"name": "quota_type", "type": "string"},
                                 {"name": "ssd_bandwidth", "type": "int64"},
                                 {"name": "ssd_storage", "type": "int64"},
                                 {"name": "vcpu", "type": "int64"},
                                 {"name": "gpu_tesla_v100", "type": "int64"},
                                 {"name": "gpu_tesla_v100_nvlink", "type": "int64"},
                                 {"name": "gpu_tesla_k40", "type": "int64"},
                                 {"name": "gpu_tesla_m40", "type": "int64"},
                                 {"name": "gpu_geforce_1080ti", "type": "int64"},
                                 {"name": "gpu_tesla_a100_80g", "type": "int64"},
                                 {"name": "gpu_tesla_a100", "type": "int64"},
                                 {"name": "ipv4", "type": "int64"},
                             ]
                     }
                     )


def collect():
    create_table()

    today = date.today().strftime("%Y-%m-%d")

    data = []
    table = yt_client.read_table('//home/data_com/cubes/yp/yp_accounts/{}'.format(today))
    datatime = time.mktime(time.strptime(today, "%Y-%m-%d"))

    for line in table:
        if "abc:" in line["account_id"]:
            line["date"] = int(datatime)
            data.append(line)
    yt_client.write_table(YT_PATH, data)


def main():
    collect()
