
import json
import datetime
import argparse
import subprocess
from collections import defaultdict

import yt.wrapper as yt


def create_table(client, path):
    client.create(
        "table",
        path,
        ignore_existing=True,
        attributes={
            "schema":
                [
                    {"name": "date", "type": "datetime"},
                    {"name": "dc", "type": "string"},
                    {"name": "segment", "type": "string"},
                    {"name": "gpu_model", "type": "string"},
                    {"name": "gpu_quota", "type": "int64"},
                    {"name": "gpu_allocation", "type": "int64"},
                ]
        }
    )


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--token', default=None)
    return parser.parse_args()


def main():
    args = parse_args()

    yt_client = yt.YtClient('hahn', token=args.token)
    table_path = '<append=true>//home/capacity_planning/gpu_spot/usage_history'

    current_date = int(datetime.datetime.now().strftime("%s"))
    service_id = 39061
    segment = 'gpu-dev'
    dcs = ['sas', 'vla']

    data = []
    for dc in dcs:
        command = (
            f'ya tool yp-util account explain abc:service:{service_id} '
            f'--node-segment {segment} --output-limit 0 --cluster {dc} --format json'
        )
        account_data = json.loads(subprocess.check_output(command, shell=True))

        gpu_limits = defaultdict(lambda: defaultdict(int))
        gpu_usage = defaultdict(lambda: defaultdict(int))
        keys = set()
        for limit in account_data['accounts_limits']:
            gpu_keys = [el for el in limit if el.startswith('gpu')]
            for gpu_key in gpu_keys:
                segment = limit['segment']
                keys.add((segment, gpu_key))
                gpu_limits[segment][gpu_key] += limit[gpu_key]

        for usage in account_data['accounts_usages']:
            gpu_keys = [el for el in usage if el.startswith('gpu')]
            for gpu_key in gpu_keys:
                segment = usage['segment']
                keys.add((segment, gpu_key))
                gpu_usage[segment][gpu_key] += usage[gpu_key]

        for segment, gpu_key in keys:
            data.append(
                {
                    'date': current_date,
                    'dc': dc,
                    'segment': segment,
                    'gpu_model': gpu_key,
                    'gpu_quota': gpu_limits[segment][gpu_key],
                    'gpu_allocation': gpu_usage[segment][gpu_key],
                }
            )

    if data:
        create_table(yt_client, table_path)
        yt_client.write_table(table_path, data)
