
import argparse

from dateutil.parser import parse

from nirvana_api import NirvanaApi
import yt.wrapper as yt
from infra.capacity_planning.library.python.yt_tables import create_table

workflow_ids = [
    '3059f005-c331-49fe-abc2-64bd3458d5b3',
    'b6b48b5a-5567-4883-ad2f-27161678f127',
    '69be3ce9-7238-4642-bb67-79f5a2ba98c8',
    'e9b14310-5977-47ae-8378-eabda38a6331',
    '1c46aee9-e421-4666-a0b2-33980f5a22e4',
    '30470680-8707-4967-b6bb-410d67cc28b7',
    '210d28c3-fe0f-4984-806d-fcd7c376dcb4',
    '3c9c2275-c885-45aa-8635-525819023f75',
    'd634b2b0-0ac4-4cfd-91de-d1d47c94fec3',
    '5c66fc68-7970-44d9-ba62-d72526f5f13c',
    '89c78a4d-faa0-4683-9c1c-70cf6003d731',
    '2a269492-a44c-4e64-af2e-853ea702d171',
    'fd3b1ab4-49b3-46f5-8f12-77e9b8c80bce',
    '61bdf93c-78f3-44a0-804d-dc95f58c60d7',

    '461766ec-6851-41ad-a902-ae6c71bd5c59',
    'a70746c0-84c1-485f-beae-2650a44075d6',
    'db04f69a-bcb8-4550-96a4-5923aa1fbf95',
    '46bc966c-182c-4212-a79c-35e8f16af606',
    '1159f661-5952-4bb7-9b67-56bbb8e9596b',
]


def put_to_yt_table(client, data):
    yt_path = '//home/capacity_planning/monitoring/task_state'
    schema = [
        'id:string',
        'name:string',
        'url:string',
        'start_date:datetime',
        'finish_date:datetime',
        'status:string',
        'message:string',
        'details:string',
    ]
    create_table(client=client, path=yt_path, schema=schema)
    client.write_table(yt_path, data)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--token', required=True)
    return parser.parse_args()


def main():
    args = parse_args()
    token = args.token

    nirvana_api = NirvanaApi(token)
    yt_client = yt.YtClient('hahn', token=token)

    total_data = []
    for workflow_id in workflow_ids:
        metadata = nirvana_api.get_workflow_meta_data(workflow_id)
        state = nirvana_api.get_execution_state(workflow_id)
        new_row = {
            'id': metadata['guid'],
            'name': metadata['name'],
            'url': f'https://nirvana.yandex-team.ru/flow/{metadata["guid"]}',
            'start_date': int(parse(state.get('started')).strftime("%s")) if state.get('started') else None,
            'finish_date': int(parse(state.get('completed')).strftime("%s")) if state.get('completed') else None,
            'status': state['result'],
            'message': state.get('message', ''),
            'details': state.get('details', ''),
        }
        total_data.append(new_row)
    put_to_yt_table(yt_client, total_data)
