#!/bin/sh
################################################################################
#                                                                              #
# This script is a part of yandex-cauth package. It does the following:        #
# 1. Checks that FQDN  matches with DNS PTR                                    #
# 2. Runs /usr/sbin/get-access.sh                                              #
# 3. Runs /usr/sbin/get-keys.sh                                                #
# 4. Runs /usr/sbin/get-sudoers.sh                                             #
# 5. Patches sshd_config to disable access for root user with password         #
#                                                                              #
#                                               zhmurov@yandex-team.ru         #
#                                                                              #
################################################################################

# Import file with CAuth functions
if [ -s /etc/cauth/cauth_functions ]; then
    . /etc/cauth/cauth_functions
else
    exit 1
fi


# Parse command line

# FIXME 
# Must be better way to get rid of "$1: unbound variable"
set +u
while [ "$1" != "" ]; do
    case $1 in

        -s | --silent )
            is_silent="true"
            export is_silent
            ;;

        -h | --help )
            echo
            echo "Usage: $0 [options...]"
            echo 
            echo "Options:"
            echo " -s, --silent        Silent mode. Don't output anything"
            echo
            exit 0
            ;;

    esac
    shift
done
# FIXME
set -u

# Do we have sufficient privileges?
is_root || p_err "you need to be root to run $0"


# Get local hostname and one from CAuth, compare it and exit, if fails
my_hostnames="$(get_my_fqdns)"
my_cauth_hostname=$($get_cmd ${fqdn_url} | awk -F'=' '!/^#/ {print $2}')
my_hostname_is_correct=0

# Check if there is no valid hostnames
if [ -z "${my_hostnames}" ] ; then
    p_err "No valid hostnames for this IP adresses in DNS.    - FAIL"
fi

# Might be multiple hostnames, compare all of it
my_hostname="unknown"
for my_hostname in ${my_hostnames} ; do
    if [ "${my_hostname}" = "${my_cauth_hostname}" ] ; then
        my_hostname_is_correct=1
    fi
done

if [ "${my_hostname_is_correct}" = 1 ] ; then
    p_info "hostname is ${my_cauth_hostname}    - OK"
else
    p_err "hostname is ${my_hostname}, but CAuth sees you as ${my_cauth_hostname}    - FAIL"
fi


# Get access config for PAM, public ssh keys and sudoers
for script in get-access.sh get-keys.sh get-sudoers.sh cauth-patch-sshd.sh; do
    if /usr/sbin/${script} ; then
        p_info "${script}   - OK"
    else
        p_err "${script}   - FAILED"
    fi
done
