#!/bin/sh
################################################################################
#                                                                              #
# This script is a part of yandex-cauth package. It does the following:        #
# 1. Patches it so that LogLevel is VERBOSE and PasswordAuthentication is no   #
# 2. PermitRootLogin without-password                                          #
#                                                                              #
#                                             abulgakov@yandex-team.ru         #
#                                                                              #
################################################################################


# Import file with CAuth functions
if [ -s /etc/cauth/cauth_functions ]; then
    . /etc/cauth/cauth_functions
else
    exit 1
fi


# global variables defined here
restart_sshd=""
sshd_config_file="/etc/ssh/sshd_config"


# Do we have sufficient privileges?
is_root || p_err "You need to be root to run $0"


# Create working directories if does not exist
create_working_dirs || p_err "Cannot create working directories"


# function searches parameters/values and edits/puts it
update_config_parameter()
{
    local _config_file _config_parameter _config_value _grep_ret

    if [ "$#" -lt 3 ] ; then
        p_err "wrong update_config_parameter function usage"
    fi

    _config_file="$1"
    _config_parameter="$2"
    _config_value="$3"


    # Try to find parameter with needed value
    grep -q "^${_config_parameter} ${_config_value}" ${_config_file} 2>/dev/null
    _grep_ret="$?"

    # if grep exited with 0, parameter already has right value, return 0
    # if grep exited with 1, parameter missing or has wrong value, fix it 
    # if grep exited with 2 or even more, something went really wrong, exit immediately
    if [ ${_grep_ret} -eq 0 ] ; then
        return 0

    elif [ ${_grep_ret} -eq 1 ] ; then
        # in case ${_config_file} was protected by chattr/chflags
        ${unprotect_file} ${_config_file}

        sed -i -e "/^${_config_parameter} /d" ${_config_file} || \
            p_err "error editing ${sshd_config_file}"
        echo "${_config_parameter} ${_config_value}" >> ${_config_file} || \
            p_err "error editing ${sshd_config_file}"
        restart_sshd="1"

    else
        p_err "error parsing ${sshd_config_file}"

    fi

    return 0
}


# Update configuration directives
update_config_parameter ${sshd_config_file} LogLevel VERBOSE
update_config_parameter ${sshd_config_file} PasswordAuthentication no
update_config_parameter ${sshd_config_file} PermitRootLogin without-password


# Check if anything has been modified
if [ ! -z "${restart_sshd}" ] ; then
    service ssh restart || true
    p_info "patching sshd_config    - OK"
else
    p_info "patching sshd_config    - NOT NEEDED"
fi
