#!/bin/sh
################################################################################
#                                                                              #
# This script is a part of yandex-cauth package. It does the following:        #
# 1. Get groups and logins allowed to login on this machine from Cauth's API   #
# 2. Write it to /etc/security/yandex-access-custom.conf file                  #
#                                                                              #
#                                               zhmurov@yandex-team.ru         #
#                                                                              #
################################################################################


# Import file with CAuth functions
if [ -s /etc/cauth/cauth_functions ]; then
    . /etc/cauth/cauth_functions
else
    exit 1
fi


# Do we have sufficient privileges?
is_root || p_err "You need to be root to run $0"


# Create working directories if does not exist
create_working_dirs || p_err "Cannot create working directories"


# Download list of server administrators from ${serveradmins_url}
fetch_file ${serveradmins_file} ${serveradmins_url} || \
    p_err "Cannot fetch ${serveradmins_url} to ${serveradmins_file}"


# Download list of users and groups from ${access_url} allowed to login
fetch_file ${access_file} ${access_url} || \
    p_err "Cannot fetch ${access_url} to ${access_file}"


# Prepare new access list
_tmp_access_file=$(mktemp ${private_tmp_dir}/tmp_access_file.XXXXXX)

if ! awk -F":" '! /^#/ {print "+ : " $1 " : ALL"}' ${serveradmins_file} > ${_tmp_access_file} ; then
    clean_garbage ${_tmp_access_file}
    p_err "Cannot write to ${_tmp_access_file}"
fi

if ! awk -F":" '/^+ : / {print "+ :" $2 ": ALL"}' ${access_file} >> ${_tmp_access_file} ; then
    clean_garbage ${_tmp_access_file}
    p_err "Cannot write to ${_tmp_access_file}"
fi

if ! echo "- : ALL : ALL" >> ${_tmp_access_file} ; then
    clean_garbage ${_tmp_access_file}
    p_err "Cannot write to ${_tmp_access_file}"
fi

# Install it to /etc/security/yandex-access-custom.conf 
if [ -s ${_tmp_access_file} ] ; then 
    if ! install -m600 -o root -g root ${_tmp_access_file} ${main_access_list} ; then
        clean_garbage ${_tmp_access_file}
        p_err "Cannot install ${_tmp_access_file} to ${main_access_list}"
    fi
fi

# Cleanup any temporary files found
rm -f ${_tmp_access_file}
