#!/bin/sh
###################################################################################
#                                                                                 #
# This script is a part of yandex-cauth package. It does the following:           #
# 1. Get serveradmins from Cauth's API                                            #
# 2. Generate NOPASSWD sudoers to /etc/sudoers.d/yandex-cauth-serveradmins        #
# 3. Get sudo rules from Cauth's API                                              #
# 4. Write it to /etc/sudoers.d/yandex-cauth file                                 #
#                                                                                 #
#                                               zhmurov@yandex-team.ru            #
#                                                                                 #
###################################################################################


# Import file with CAuth functions
if [ -s /etc/cauth/cauth_functions ]; then
    . /etc/cauth/cauth_functions
else
    exit 1
fi


# Do we have sufficient privileges?
is_root || p_err "You need to be root to run $0"


# Create working directories if does not exist
create_working_dirs || p_err "Cannot create working directories"


# get_users_sudoers()
#  This function downloads new sudoers from ${sudoers_url}
#  and installs it to ${main_sudoers_file}.
#  See /etc/cauth/cauth_functions for details
#
get_users_sudoers()
{
    local _cur_sudoers _new_sudoers _tmp_sudoers_file

    fetch_file ${sudoers_file} ${sudoers_url}

    _new_sudoers="$(grep -Ev "(^#)|(%serveradmins)" ${sudoers_file})"
    _cur_sudoers="$(cat ${main_sudoers_file} 2>/dev/null)"

    if [ "${_new_sudoers}" != "${_cur_sudoers}" ] ; then

        _tmp_sudoers_file=$(mktemp ${private_tmp_dir}/tmp_sudoers_file.XXXXXX)
        if ! echo "${_new_sudoers}" > ${_tmp_sudoers_file} ; then
            clean_garbage ${_tmp_sudoers_file}
            p_err "Cannot write to ${_tmp_sudoers_file}"
        fi

        install -m0440 -o root -g root ${_tmp_sudoers_file} ${main_sudoers_file}
        rm -f ${_tmp_sudoers_file}

    else
        # if permissions of sudoers file is incorrect, fix it
        if [ -f ${main_sudoers_file} ] ; then
            if [ "$(stat ${stat_ugp_opts} ${main_sudoers_file})" != "rootroot440" ] ; then
                chmod 440 ${main_sudoers_file}
                chown root:root ${main_sudoers_file}
            fi
        fi

    fi
}


# get_admins_sudoers()
#  This function downloads list of local admins and puts them
#  to ${main_sudoers_file}-serveradmins file, so serveradmins always have sudo
#  See /etc/cauth/cauth_functions for details
#
get_admins_sudoers()
{
    local _cur_sudoers _new_sudoers _tmp_sudoers_file

    fetch_file ${serveradmins_file} ${serveradmins_url}

    _new_sudoers="$(awk -F":" '! /^#/ {print $1" ALL=(ALL) NOPASSWD: ALL"}' ${serveradmins_file})"
    _cur_sudoers="$(cat ${main_sudoers_file}-serveradmins 2>/dev/null)"


    if [ "${_new_sudoers}" != "${_cur_sudoers}" ] ; then
        _tmp_sudoers_file=$(mktemp ${private_tmp_dir}/tmp_sudoers_file-serveradmins.XXXXXX)
        if ! echo "${_new_sudoers}" > ${_tmp_sudoers_file} ; then
            clean_garbage ${_tmp_sudoers_file}
            p_err "Cannot write to ${_tmp_sudoers_file}"
        fi

        install -m0440 -o root -g root ${_tmp_sudoers_file} ${main_sudoers_file}-serveradmins
        rm -r ${_tmp_sudoers_file}

    else
        # if permissions of sudoers file is incorrect, fix it
        if [ -f ${main_sudoers_file} ] ; then
            if [ "$(stat ${stat_ugp_opts} ${main_sudoers_file}-serveradmins)" != "rootroot440" ] ; then
                chmod 440 ${main_sudoers_file}-serveradmins
                chown root:root ${main_sudoers_file}-serveradmins
            fi
        fi

    fi
}


get_users_sudoers
get_admins_sudoers
