#!/bin/sh

ret=0
rss=""
pids=""
sssd_processes="sssd_be sssd_nss sssd_pam sssd"

# check if all sssd processes are alive
for process in ${sssd_processes} ; do
    killall -0 ${process} 2>/dev/null || ret=1
done


# check if any of pids is eating memory (more than 512MB)
pids="$(pidof ${sssd_processes})"
for pid in ${pids} ; do
    rss="$(ps ho rss ${pid})"
    if [ ! -z "${rss}" ] ; then
       [ ${rss} -lt 524288 ] || ret=1
    else
        ret=1
    fi
done


# sssd cache MUST(!) be stored in memory
# otherwise authentications may fails on heavy IO servers
# check that sssd cache stored in memory, not on disk 
if [ ! -d "/var/run/sssd" ] ; then
    ret=1
elif [ "$(readlink /var/lib/sss/db)" != "/var/run/sssd" ] ; then
    ret=1
fi


# Sometimes sssd_nss stalls with no answer CAUTH-1447
if [ -x $(which timeout) ] ; then
    timeout 15 getent passwd cauth_watchdog > /dev/null 2>&1
    # 124: timeout exceeded
    if [ "$?" = 124 ] ; then
        ret=1
    fi
fi


# if one of any checks above returned 1 - restart sssd
if [ "$ret" = 1 ] ; then
    service sssd stop > /dev/null 2>&1

    sleep 2

    rm -rf /var/lib/sss/db
    rm -f /var/run/sssd.pid

    mkdir -p -m0770 /var/run/sssd
    ln -sfT /var/run/sssd /var/lib/sss/db

    service sssd start > /dev/null 2>&1
fi
