#!/usr/bin/env python

conf_file = '/usr/share/pam-configs/cauth'
with open(conf_file) as fd:
    ubuntu_rules = fd.readlines()
sections = ('auth', 'account', 'password', 'session')
rhel_rules = dict(zip(sections, [list() for i in sections]))
section = ''
for line in ubuntu_rules:
    if line.split(':')[0].lower() in sections:
        section = line.split(':')[0].lower()
    if section and line.startswith('\t'):
        rule = line.rstrip()
        rhel_rules[section].append('{0}\t{1}'.format(section, rule))
for section in sections:
    if not rhel_rules[section]:
        continue
    with open('/etc/pam.d/yandex-{0}'.format(section), 'w') as fd:
        fd.write('\n'.join(rhel_rules[section] + ['']))

