%define _builddir	.
%define _sourcedir	.
%define _specdir	.
%define _rpmdir		.

%{!?deb_version: %define deb_version %{expand:%%(head -1 debian/changelog | cut -d '(' -f 2 | cut -d '-' -f 1; #))} }
%{!?deb_release: %define deb_release %{expand:%%(head -1 debian/changelog | cut -d '(' -f 2 | cut -d '-' -f 2 | cut -d ')' -f 1)} }
%{!?deb_release: %define deb_release 1 }

Name:		yandex-cauth
Version:	%deb_version
Release:	%deb_release
URL:		https://github.yandex-team.ru/cauth/yandex-cauth
Summary:	Yandex cauth agent
License:	Yandex License
Group:		System Environment/Libraries
Distribution:	Red Hat Enterprise Linux

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root

Requires:	curl, diffutils, gawk, hostname, psmisc, util-linux >= 2.23.2-44, sssd, procps, authconfig, sysvinit-tools
Obsoletes:	cauth-agent


%description
Yandex cauth agent

%install
%{__rm} -rf %{buildroot}

%{__mkdir} -p %{buildroot}%{_sysconfdir}/sssd
%{__install} -p -m 600 src/etc/sssd/sssd.conf %{buildroot}%{_sysconfdir}/sssd/yandex-sssd.conf

%{__mkdir} -p %{buildroot}%{_sysconfdir}/ldap/certs
%{__install} -p -m 600 src/etc/ldap/certs/cafile.pem %{buildroot}%{_sysconfdir}/ldap/certs/cafile.pem

%{__mkdir} -p %{buildroot}%{_sysconfdir}/cauth
%{__install} -p -m 744 src/etc/cauth/cauth_functions %{buildroot}%{_sysconfdir}/cauth/cauth_functions

%{__mkdir} -p %{buildroot}%{_sysconfdir}/cron.d
%{__install} -p -m 644 debian/cron.d %{buildroot}%{_sysconfdir}/cron.d/yandex-cauth

%{__mkdir} -p %{buildroot}%{_sysconfdir}/security
%{__install} -p -m 600 src/etc/security/* %{buildroot}%{_sysconfdir}/security

%{__mkdir} -p %{buildroot}%{_sysconfdir}/sudoers.d
%{__install} -p -m 600 src/etc/sudoers.d/yandex-cauth-ssh-agent %{buildroot}%{_sysconfdir}/sudoers.d

%{__mkdir} -p %{buildroot}%{_sysconfdir}/monrun/conf.d
%{__install} -p -m 600 src/etc/monrun/conf.d/yandex-cauth.conf %{buildroot}%{_sysconfdir}/monrun/conf.d

%{__mkdir} -p %{buildroot}%{_bindir}
%{__install} -p -m 744 src/usr/bin/* %{buildroot}%{_bindir}/

%{__mkdir} -p %{buildroot}%{_sbindir}
%{__install} -p -m 744 src/usr/sbin/* %{buildroot}%{_sbindir}/

%{__mkdir} -p %{buildroot}%{_datarootdir}/pam-configs
%{__install} -p -m 600 src/usr/share/pam-configs/cauth %{buildroot}%{_datarootdir}/pam-configs

%{__mkdir} -p %{buildroot}%{_datarootdir}/yandex-cauth
%{__install} -p -m 644 src/usr/share/yandex-cauth/cauth.conf-example %{buildroot}%{_datarootdir}/yandex-cauth/
%{__install} -p -m 755 src_rpm/pam_config_converter.py %{buildroot}%{_datarootdir}/yandex-cauth/

%{__mkdir} -p %{buildroot}/usr/lib/tmpfiles.d
%{__install} -p -m 600 src/usr/lib/tmpfiles.d/sssd.conf %{buildroot}/usr/lib/tmpfiles.d/

%clean
rm -rf $RPM_BUILD_ROOT

%post
# Convert ubuntu's PAM metaconfigs
/usr/share/yandex-cauth/pam_config_converter.py

# Replace dpkg-query with rpm -q
sed -i 's/dpkg-query -f=\x27${Version}\x27 -W/rpm -q --qf=\x27%\{VERSION\}\x27/' /etc/cauth/cauth_functions

# Disable fetching admins keys
sed -ri 's/(^\s+fetch_file \$\{root_keys_file\} .*$)/#\1/' /usr/sbin/get-keys.sh

# Allow root login with password
sed  -ri 's/(^update_config_parameter.*PasswordAuthentication.*$)/#\1/' /usr/sbin/cauth-patch-sshd.sh
sed  -ri 's/(^update_config_parameter.*PermitRootLogin.*$)/#\1/' /usr/sbin/cauth-patch-sshd.sh

# Add sssd
grep "^passwd:.*sss.*" /etc/nsswitch.conf >/dev/null || sed -i -e "s/^\(passwd:.*\)/\1 sss/" /etc/nsswitch.conf
grep "^group:.*sss.*" /etc/nsswitch.conf >/dev/null || sed -i -e "s/^\(group:.*\)/\1 sss/" /etc/nsswitch.conf

# Configuring sshd pam config 
[ -f /etc/pam.d/sshd ] && sed -i '/^account.*include.*\(system\|password\)-auth/ s/^/#/;$ a account    include      yandex-account\nsession    include      yandex-session' /etc/pam.d/sshd

# Fix symlinks from older packages
readlink /etc/pam.d/system-auth | grep -q yandex && ln -sf /etc/pam.d/system-auth-ac /etc/pam.d/system-auth || true
readlink /etc/pam.d/smartcard-auth | grep -q yandex && ln -sf /etc/pam.d/smartcard-auth-ac /etc/pam.d/smartcard-auth || true

# fix permissions for sssd stuff
chmod 0755 /etc/cauth
chmod 0600 /etc/sssd/sssd.conf
chmod 0644 /etc/ldap/certs/cafile.pem
chmod 0600 /etc/security/yandex-access.conf

# making /sbin/nologin symlink to allow nologin shell works properly CAUTH-1194
if [ ! -e /sbin/nologin ]; then
    ln -sf $(which nologin) /sbin/nologin || true
fi

# In case this system is running systemd, we need to ensure that all
# necessary tmpfiles (if any) are created before starting.
%{?el7:systemd-tmpfiles --create /usr/lib/tmpfiles.d/sssd.conf >/dev/null || true}

# SSSD cache MUST be placed to RAM (tmpfs)
# to work properly under heavy IO loads
service sssd stop || true
rm -f /dev/shm/*.ldb || true
rm -rf /var/lib/sss/db || true
ln -sfT /var/run/sssd /var/lib/sss/db || true
service sssd start || true

# Trying to refresh cauth.conf
/usr/sbin/agent.sh 2>&1 || true

# regenerate monrun tasks if monrun installed
[ -x /var/cron.d/check_monrun.sh ] && /var/cron.d/check_monrun.sh || true
[ -x /usr/sbin/regenerate-monrun-tasks ] && /usr/sbin/regenerate-monrun-tasks || true

# clean old files from other cauth packages
rm -f /etc/sudoers.d/cauth /etc/sudoers.d/yandex-search-cauth-serveradmins /etc/cron.d/cauth-client-scripts || true
rm -rf /etc/cauth/spool || true

# Creating /etc/sssd/sssd.conf
[ -f /etc/sssd/sssd.conf ] && mv -f /etc/sssd/sssd.conf /etc/sssd/sssd.conf.bak;
ln -fs %{_sysconfdir}/sssd/yandex-sssd.conf %{_sysconfdir}/sssd/sssd.conf

# Enabling sssd auth
%{?el6:authconfig --updateall --enablepamaccess --enablesssd --enablesssdauth --enablemkhomedir --disablefingerprint}
%{?el6:/sbin/chkconfig sssd on}
%{?el7:authconfig --updateall --enablepamaccess --enablesssd --enablesssdauth --enablemkhomedir}
%{?el7:systemctl enable sssd}

# Reloading services
service crond restart
service sssd restart

%preun
if [ $1 = 0 ]; then
	[ -f /etc/pam.d/sshd ] && sed -i '/^#account.*include.*\(system\|password\)-auth/s/#//; /account.*include.*yandex-account/d; s/session.*include.*yandex-session/d;' /etc/pam.d/sshd || :
	[ -h /etc/sssd/sssd.conf ] && rm -f /etc/sssd/sssd.conf; mv -f /etc/sssd/sssd.conf.bak /etc/sssd/sssd.conf || :
fi
exit 0

%files
%defattr(-, root, root)
%{_bindir}/cauth-info
%{_bindir}/cauth-check-cache
%{_sbindir}/agent.sh
%{_sbindir}/cauth-patch-sshd.sh
%{_sbindir}/get-access.sh
%{_sbindir}/get-sudoers.sh
%{_sbindir}/get-keys.sh
%{_sbindir}/sssd-watchdog.sh
%{_sysconfdir}/cauth/cauth_functions
%{_sysconfdir}/cron.d/yandex-cauth
%{_sysconfdir}/ldap/certs/cafile.pem
%{_sysconfdir}/monrun/conf.d/yandex-cauth.conf
%{_sysconfdir}/security/yandex-access.conf
%{_sysconfdir}/security/yandex-deny.conf
%{_sysconfdir}/sssd/yandex-sssd.conf
%{_sysconfdir}/sudoers.d/yandex-cauth-ssh-agent
%{_datarootdir}/pam-configs/cauth
%{_datarootdir}/yandex-cauth/cauth.conf-example
%{_datarootdir}/yandex-cauth/pam_config_converter.py
/usr/lib/tmpfiles.d/sssd.conf

%changelog
