package commands

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/cauth/agent/linux/cauth-agent/internal/config"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

const (
	defaultCfgPath = "/etc/cauth/agent.yaml"
)

var (
	cfg     *config.Config
	cfgPath string
	logger  log.Logger
)

var rootCmd = &cobra.Command{
	Use:          "cauth",
	SilenceUsage: true,
	Short:        "CAuth agent",
	PersistentPreRunE: func(cmd *cobra.Command, args []string) (err error) {
		if cfgPath == "" {
			if _, err := os.Stat(defaultCfgPath); !os.IsNotExist(err) {
				cfgPath = defaultCfgPath
			}
		}

		cfg, err = config.NewConfig(cfgPath)
		if err != nil {
			return fmt.Errorf("failed to parse config: %w", err)
		}

		logger, err = zap.New(cfg.Log.ZapConfig())
		if err != nil {
			return fmt.Errorf("failed to initialize logger: %w", err)
		}
		return nil
	},
}

func Main() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}

func init() {
	flags := rootCmd.PersistentFlags()
	flags.StringVarP(&cfgPath, "config", "c", "",
		fmt.Sprintf("config path (default: %s)", defaultCfgPath),
	)
}
