#pragma once
#include <infra/cauth/agent/linux/flatcache/cache.fbs.h>
#include <util/system/filemap.h>
#include <util/system/mutex.h>
#include <util/system/rwlock.h>

namespace NCAuth::NSS {

    class TCache {
    public:
        explicit TCache(TString cachePath, bool stale = false);

        const NCAuth::NFlatCache::User* UserByUid(ui32 uid);

        const NCAuth::NFlatCache::User* UserByLogin(const char* login);

        const NCAuth::NFlatCache::Group* GroupByGid(ui32 gid);

        const NCAuth::NFlatCache::Group* GroupByName(const char* groupName);

    protected:
        void Remap(bool force = false);

        bool stale;
        ui64 inode;
        const TString cachePath;
        THolder<TFileMap> mCache;
        TRWMutex mu;
        const NCAuth::NFlatCache::Cache* cache;
    };

    class TUserIterator : TCache {
    public:
        explicit TUserIterator(const TString& cachePath);

        bool Next();

        const NCAuth::NFlatCache::User* User();

        void Stop();

    private:
        bool started;
        bool stopped;
        TMutex mu;
        flatbuffers::Vector<flatbuffers::Offset<NCAuth::NFlatCache::User>>::const_iterator begin;
        flatbuffers::Vector<flatbuffers::Offset<NCAuth::NFlatCache::User>>::const_iterator end;
    };

    class TGroupIterator : TCache {
    public:
        explicit TGroupIterator(const TString& cachePath);

        bool Next();

        const NCAuth::NFlatCache::Group* Group();

        void Stop();

    private:
        bool started;
        bool stopped;
        TMutex mu;
        flatbuffers::Vector<flatbuffers::Offset<NCAuth::NFlatCache::Group>>::const_iterator begin;
        flatbuffers::Vector<flatbuffers::Offset<NCAuth::NFlatCache::Group>>::const_iterator end;
    };

}
