#include "utils.h"
#include  <cstdlib>

namespace NCAuth::NSS::NUtils {

    TBufferManager::TBufferManager(char* buf, size_t buflen) :
            buf(buf),
            buflen(buflen) {}

    bool TBufferManager::AppendString(std::string_view value, char** buffer, int* errnop) {
        size_t bytes_to_write = value.length() + 1;
        *buffer = static_cast<char*>(Reserve(bytes_to_write, errnop));
        if (*buffer == nullptr) {
            return false;
        }

        strncpy(*buffer, value.data(), bytes_to_write);
        return true;
    }

    bool TBufferManager::CheckSpace(size_t bytes_to_write) const {
        if (bytes_to_write > buflen) {
            return false;
        }
        return true;
    }

    void* TBufferManager::Reserve(size_t bytes, int* errnop) {
        if (!CheckSpace(bytes)) {
            *errnop = ERANGE;
            return nullptr;
        }
        void* result = buf;
        buf += bytes;
        buflen -= bytes;

        return result;
    }

} // namespace NCAuth::NSS::NUtils
