#include <string_view>
#include <cerrno>
#include <util/generic/noncopyable.h>


namespace NCAuth::NSS::NUtils {

    class TBufferManager : TNonCopyable {
    public:
        TBufferManager(char* buf, size_t buflen);

        bool AppendString(std::string_view value, char** buffer, int* errnop);

        void* Reserve(size_t bytes, int* errnop);

    private:
        [[nodiscard]] bool CheckSpace(size_t bytes_to_write) const;

        char* buf;
        size_t buflen;
    };

}